function lectureGBNS
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function lectureGBNS
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% Demo containing a "lecture" on numerical stability of schemes for PDE's.
% Has the following parts:
% PART = 1
%   The dangers of Naive numerical schemes: NUMERICAL INSTABILITIES:
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

colormap(hsv)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%% PART I of LECTURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Nskip = [];
fprintf('\n Lecture has three parts. To see PART I enter 1 now. \n')
Nskip = input(' Enter 1 to see PART I, else press return ....... CHOICE = ');
if Nskip == 1 % ---- THIS if ENDS AT THE END OF PART I.
% ----------------------------------------------------- Intro text -----------
fprintf('\n')
disp([ ...
  ' ____________________________________________________________________'; ...
  ' The dangers of Naive numerical schemes: NUMERICAL INSTABILITIES:    '; ...
  '                                                                     '; ...
  ' Consider the wave equation in 1-D:    u_tt = u_xx, for u(x, t).     '; ...
  ' Introducing v = u_t this yields: /     u_t = v     and              '; ...
  '                                  \     v_t = u_xx,                  '; ...
  ' which has the advantage of being written as a first order  (in time)'; ...
  ' system. We can now replace the derivatives in the equation by finite'; ...
  ' differences (with dt & dx small) to get (up to terms of O(dx^2, dt))'; ...
  '                                                                     '; ...
  '  {u(x,t+dt)-u(x,t)}/dt = v(x,t) and {v(x,t+dt)-v(x,t)}/dt = u2(x,t),'; ...
  '                                                                     '; ...
  ' where u2(x, t) = {u(x+dx,t)-2*u(x,t)+u(x-dx,t)}/(dx)^2 ~ u_xx(x, t).'; ...
  '                                                                     '; ...
  ' Consider now a discrete grid     x_n = x_0 + n*dx   and   t_l = l*dt'; ...
  ' and evaluate the solution on it / u_n^l = u(x_n, t_l),              '; ...
  '                                 \ v_n^l = v(x_n, t_l).              '; ...
  '                                                                     '; ...
  ' The approximation above then yields the solution at time t = t_{l+1}'; ...
  ' once it is known at time t_l. Thus it yields a numerical scheme that'; ...
  ' should give the solution with errors O(dx^2, dt) ... or WILL IT?    '; ...
  '                                           Press any key to continue.']);
pause
disp([ ...
  '                                                                     '; ...
  ' LET US CHECK THIS OUT: .............................................'; ...
  ' Next we show the results of some computations in the interval -1<x<1'; ...
  ' using this scheme. Periodic boundary conditions & sinusoidal initial'; ...
  ' data are used. We take:      u(x, 0) = 0.5*{1+cos(pi*x)},           '; ...
  '                              v(x, 0) = 0,                           '; ...
  ' dx = 2/N (various values of N), dt = dx/2 and compute for 0 < t < 2.'; ...
  ' ____________________________________________________________________'; ...
  ' PRESS ANY KEY TO CONTINUE and SEE THE RESULTS OF THE CALCULATIONS.  ']);
pause
%
% ----------------------------------------- Now we do the calculations. ------
%
% ---- Use cosine initial condition, bad scheme.   One period in space (a = 1)
%      and time (t_f = 2) and plot with mesh(x, T, U).
a   = 1;
t_f = 2;
N   = [40, 50, 55, 57, 60, 80];
%
% TEXT = COMMENTS TO GO ALONG WITH THE PICTURES (will be printed on screen).
% NTEXT(n+1) records the number of the last line in comment number n.
%
TEXT = [ ...
%
% CASE N = 40. Works basically OK.
%
  ' First we try N = 40 points in space.   We obtain a rather reasonable'; ...
  ' looking solution ... though not quite right:   The exact solution is'; ...
  ' periodic in time and reproduces the initial data at time t = 2.  But'; ...
  ' here we can see that the amplitude has gone UP at t = 2 !!          '; ...
  ' Thus: decrease dx and dt. This should give a better approximation.  '; ...
  '                                           Press any key to continue.'; ...
%
% CASE N = 50. Note small noise near x = 0 and  t = 2.
%
  ' Except that IT DOES NOT. With N = 50 points in space, what we end up'; ...
  ' with is some small noise near the maximum of the solution for t near'; ...
  ' 2. Let us check what happens if we keep increasing N.               '; ...
  '                                           Press any key to continue.'; ...
%
% CASE N = 55. Noise gets bigger.
%
  ' With N = 55, the noise gets bigger and is now clearly visible.      '; ...
  '                                           Press any key to continue.'; ...
%
% CASE N = 57. Noise is as big as the rest of the solution.
%
  ' With N = 57, it is starting to be hard to distinguish the noise from'; ...
  ' the solution.  It is quite clear that, as we decrease dx and dt, not'; ...
  ' only is the numerical solution failing to get better;  in fact it is'; ...
  ' GETTING WORSE!                            Press any key to continue.'; ...
%
% CASE N = 60. Worsening trend continues.
%
  ' With N = 60,  the trend continues,  with noise completely dominating'; ...
  ' the numerical solution!                   Press any key to continue.'; ...
%
% CASE N = 80. Disaster.
%
  ' Finally, with N = 80, we have a complete DISASTER!                  '; ...
  ' Notice that the noise has now a HUGE amplitude, of order 10^7!      '; ...
  ' For larger N this disaster gets EXPONENTIALLY worse!                '; ...
  '                                           Press any key to continue.'];
%
NTEXT = [0, 6, 10, 12, 16, 18, 22];
%
for n=1:6
   [x, T, U, V, M] = InitGBNS(N(n), a, t_f, 'C', 'B');
   umin = floor(11*min(min(U)))/10;
   umax = ceil(11*max(max(U)))/10;
   f = figure;
   whitebg(f, 'k')
   mesh(x, T, U)
   shading flat   % options are: faceted, interp, flat
   % colormap(hsv)
   axis([-1 1 0 2 umin umax])
   grid on
   hold on
   set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
   NRES = num2str(N(n));
   title(['{\bf Numerical solution u = u(x, t) with N = ', NRES, ...
          ' points.}'], 'FontSize', 18)
   xlabel('{\bf Space x -- dx=2/N.}', 'FontSize', 18)
   ylabel('{\bf Time t -- dt=1/N.}',  'FontSize', 18)
   zlabel('{\bf u }', 'FontSize', 18, 'Rotation', 0, ...
          'HorizontalAlignment', 'right')
   fprintf('\n')
   disp(TEXT((NTEXT(n)+1):NTEXT(n+1), :))
   pause
end
%
fprintf('\n')
disp([ ...
  ' Notice now (in the plot of the solution at time t = 2) how the noise'; ...
  ' is actually made up of very large amplitude oscillations. These have'; ...
  ' a wavelength of two grid spacings.    That is, in the numerical grid'; ...
  ' they show up as an alternating up and down in the solution.         '; ...
  '                                           Press any key to continue.']);
  
f = figure;
whitebg(f, 'k')
plot(x, U(M, :), '-c', 'LineWidth', 2)
set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
hold on
title(['{\bf Numerical solution u with N = ', ...
       NRES, ' points.}'], 'FontSize', 18)
xlabel('{\bf Space x -- dx=2/N.  Solution for time t = 2}', 'FontSize', 18)
ylabel('{\bf u. }',  'FontSize', 18, 'Rotation', 0, ...
       'HorizontalAlignment', 'right')
%
end % THIS ENDS the IF started at the beginning of PART I.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF PART I %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%% PART II of LECTURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Nskip = [];
fprintf('\n')
fprintf('\n Lecture has three parts. To see PART II enter 1 now. \n')
Nskip = input(' Enter 1 to see PART II, else press return ...... CHOICE = ');
if Nskip == 1 % ---- THIS if ENDS AT THE END OF PART II.
% ----------------------------------------------------- Intro text -----------
fprintf('\n')
disp([ ...
  ' ____________________________________________________________________'; ...
  ' We now carry a different test  (of the naive algorithm introduced in'; ...
  ' in PART I). Instead of changing dx, we will keep dx fixed and change'; ...
  ' the initial conditions.        Specifically, we still compute in the'; ...
  ' interval -1 < x < 1 (with periodic boundary conditions), but use for'; ...
  ' the initial data a Gaussian profile    u(x, 0) = exp(-a*log(10)*x^2)'; ...
  '                                 and    v(x, 0) = 0,                 '; ...
  ' for various values of a.                                            '; ...
  ' We use N = 100 points in the interval, with dx = 2/N, dt = dx/2 and '; ...
  ' compute for 0 < t < 0.5.                                            '; ...
  ' Note that the Gaussian profile above is not periodic, as is the case'; ...
  ' with the cosine in PART I.    Thus, the periodic boundary conditions'; ...
  ' introduce a corner in the initial data, at the ends of the interval.'; ...
  ' This corner gets "sharper" as "a" decreases, since then the Gaussian'; ...
  ' looks less and less flat near the ends of the interval.             '; ...
  '                                           Press any key to continue.']);
pause
disp([ ...
  '                                                                     '; ...
  ' What we will observe is that this corner triggers the same phenomena'; ...
  ' we observed in PART I,  with grid scale oscillations that get bigger'; ...
  ' as "a" decreases (sharper corner):                                  '; ...
  '  Oscillations are first noticeable for a = 7 near (x,t) = (-1, 0.5) '; ...
  '  """""""""""" are big              """ a = 5,                       '; ...
  '  """""""""""" are huge             """ a = 4.                       '; ...
  ' ____________________________________________________________________'; ...
  ' PRESS ANY KEY TO CONTINUE and SEE THE RESULTS OF THE CALCULATIONS.  ']);
N   = 100;
t_f = 0.5;
a   = [15, 10, 7, 6, 5, 4];
%
for n=1:6
   [x, T, U, V, M] = InitGBNS(N, a(n), t_f, 'G', 'B');
   umin = floor(11*min(min(U)))/10;
   umax = ceil(11*max(max(U)))/10;
   pause
   f = figure;
   whitebg(f, 'k')
   mesh(x, T, U)
   shading flat   % options are: faceted, interp, flat
   % colormap(hsv)
   axis([-1 1 0 0.5 umin umax])
   hold on
   set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
   grid on
   NRES = num2str(a(n));
   title(['{\bf Numerical solution u = u(x, t) with a = ', NRES, '.}'], ...
          'FontSize', 18)
   xlabel('{\bf Space x -- dx=0.02.}', 'FontSize', 18)
   ylabel('{\bf Time t -- dt=0.01.}', 'FontSize', 18)
   zlabel('{\bf u }', 'FontSize', 18, 'Rotation', 0, ...
          'HorizontalAlignment', 'right')
   if n < 6
      fprintf('\n Press any key to see the next value of a')
   end
end
%
%
end % THIS ENDS the IF started at the beginning of PART II.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF PART II %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%% PART III of LECTURE %%%%%%%%%%%%%%%%%%%%%%%%%%%%
Nskip = [];
fprintf('\n')
fprintf('\n Lecture has three parts. To see PART III enter 1 now. \n')
Nskip = input(' Enter 1 to see PART III, else press return ..... CHOICE = ');
if Nskip == 1 % ---- THIS if ENDS AT THE END OF PART III.
% ----------------------------------------------------- Intro text -----------
fprintf('\n')
disp([ ...
  ' ____________________________________________________________________'; ...
  ' The problem here is that the naive scheme introduced in PART I fails'; ...
  ' to be stable. This can be shown via a von Neumann stability analysis'; ...
  ' of the scheme.     This analysis shows that all the scheme solutions'; ...
  ' blow up exponentially, the faster the shorter the wavelength -- this'; ...
  ' explains why in our calculations the solutions ended up dominated by'; ...
  ' grid scale oscillations.                                            '; ...
  '                                           Press any key to continue.']);
pause
disp([ ...
  '                                                                     '; ...
  ' One simple way to fix the problem is to add "numerical viscosity" to'; ...
  ' the scheme. This will kill oscillations, the fastest the shorter the'; ...
  ' wavelength. Thus one can "tune-up" this viscosity so that the scheme'; ...
  ' behaves properly.   The following scheme is an example of using this'; ...
  ' technique on the naive scheme we have been using so far:            '; ...
  '                                                                     '; ...
  '        u(x,t+dt) = u(x,t) +  v(x,t)*dt + u2(x,t)*eta,               '; ...
  '        v(x,t+dt) = v(x,t) + u2(x,t)*nu + v2(x,t)*eta,               '; ...
  '                                                                     '; ...
  ' where nu  = dt/(dx)^2 and eta = (dt/dx)^2.  u2 and v2 are as defined'; ...
  ' in PART I. This scheme is stable if dt <= 0.5*dx.                   '; ...
  '                                           Press any key to continue.']);
pause
disp([ ...
  '                                                                     '; ...
  ' NOTES: a) This scheme works, but it is far from being "best around".'; ...
  '           We introduce it here just as an illustration.             '; ...
  '        b) For more information on these two schemes, the von Neumann'; ...
  '           stability analysis, etc., see the notes:   Num_Scheme_Stab'; ...
  '           (in pdf or postscript or LaTex) in the Athena 18311 locker'; ...
  '           (subdirectory Notes). Also posted in the 18311 WEB page as'; ...
  '           "Stability of Numerical Schemes for PDE_s".               '; ...
  '        c) A good book to check is:   "Numerical Recipies", by Press,'; ...
  '           Teukolsky, Vetterling and Flannery, Cambridge U. Press.   '; ...
  '                                                                     '; ...
  ' Next we carry exactly the same calculations as in PART I,   but with'; ...
  ' the new scheme. Most IMPORTANT thing to notice is that there are now'; ...
  ' NO OSCILLATIONS.  Second point is that now, at t=2, the initial data'; ...
  ' are not reproduced (as they are for the exact solution) but, instead'; ...
  ' of being amplified (as the first scheme does), they are damped (with'; ...
  ' the amount of damping going down as dx decreases).    This is due to'; ...
  ' added numerical dissipation.                                        '; ...
  ' THE LAST figure (N=160) shows how, with enough points, we get pretty'; ...
  ' close to the right answer --- as commented above in (a), this scheme'; ...
  ' is not too hot.   A good scheme could have achieved this same result'; ...
  ' far less points!                                                    '; ...
  ' ____________________________________________________________________'; ...
  ' PRESS ANY KEY TO CONTINUE and SEE THE RESULTS OF THE CALCULATIONS.  ']);
%
a   = 1;
t_f = 2;
N   = [40, 50, 55, 57, 60, 80, 160];
%
for n=1:7
   pause
   [x, T, U, V, M] = InitGBNS(N(n), a, t_f, 'C', 'G');
   umin = floor(11*min(min(U)))/10;
   umax = ceil(11*max(max(U)))/10;
   f = figure;
   whitebg(f, 'k')
   mesh(x, T, U)
   shading flat   % options are: faceted, interp, flat
   % colormap(hsv)
   axis([-1 1 0 2 umin umax])
   hold on
   set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
   grid on
   NRES = num2str(N(n));
   title(['{\bf Numerical solution u = u(x, t) with N = ', ...
          NRES, ' points.}'], 'FontSize', 18)
   xlabel('{\bf Space x -- dx=2/N.}', 'FontSize', 18)
   ylabel('{\bf Time t -- dt=1/N.}', 'FontSize', 18)
   zlabel('{\bf u }', 'FontSize', 18, 'Rotation', 0, ...
          'HorizontalAlignment', 'right')
   fprintf('\n Press any key to see the next figure.')
end
%
end % THIS ENDS the IF started at the beginning of PART III.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%% END OF PART III %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
fprintf('\n End of lecture. Bye!')
LINE = '____________________________________________________________________';
fprintf(['\n', LINE, '\n'])
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-15-2001.
% Update     by Rodolfo R. Rosales  02-25-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  
%%%  End of File.
