function demoGBNS(OPTION, N)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function demoGBNS(OPTION, N)
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% Solves (and plots) the wave equation: u_tt - u_xx = 0 for 0 < t < 2 and x in
% [-1, 1].  Uses periodic boundary conditions and initial values u(x,0) either
% Gaussian or Sinusoidal (with u_t vanishing).    Needed inputs are via screen
% requests or given when calling the script.
%
% This demo gives the option of running TWO examples using the function script
% InitGBNS with  pre-chosen parameters.  Then it can show the answer as either
% (or both) a 2-D plot or a frame by frame slide show.
%
% The demo uses the "Good" scheme option in InitGBNS.  However, note that this
% scheme is not all that "good" in terms of efficiency.
%                                                  See InitGBNS and readmeGBNS
%
% INPUTS (both optional, enter either both or skip both.)
% If the input's are not given, they are requested interactively.
%
% OPTION = 1 .... Gaussian   initial dada.
% OPTION = 2 .... Sinusoidal initial data.
% N      =  ..... Number of points used in the numerical (space) grid.    Many
%                 points give good resolution, but slow down things. N = 50 is
%                 reasonable (but not too accurate).   Go to 200 or higher for
%                 good pictures, and WAIT.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin < 2
   fprintf('\n')
   disp([' This demo shows a solution of the wave equation'; ...
         '                   u_tt - u_xx = 0              '; ...
         ' with periodic boundary conditions in -1 < x < 1'; ...
         ' and two choices of initial data.               '; ...
         ' The options are:                               '; ...
         '     OPTION = 1 Gaussian   initial dada,        '; ...
         '     OPTION = 2 Sinusoidal initial data.        '])
   %
   OPTION = input(' Enter ................................. OPTION = ');
   if isempty(OPTION); OPTION = 1; end
   %
   fprintf('\n')
   disp([' Choose the number of points in the space x-grid. '; ...
         ' Many points give good resolution,  but slow down '; ...
         ' things.                                          '; ...
         ' N = 50 is reasonable (but not too accurate).     '; ...
         ' Go to 200 or higher for good pictures, and WAIT. '])
   %
   N = input(' Enter ...................................... N = ');
   if isempty(N); N = 50; end
   %
end
%
if OPTION == 1
   [x, T, U, V, M] = InitGBNS(N, 10, 2, 'G', 'G');
elseif OPTION == 2
   [x, T, U, V, M] = InitGBNS(N,  1, 2, 'C', 'G');
end
%
CHOICE = 1;
while CHOICE < 3
   fprintf('\n You have now the following CHOICES: ')
   fprintf('\n CHOICE = 1 ... 3-D plot of the solution u = u(x, t).')
   fprintf('\n        = 2 ... Slide show of the time evolution of u.')
   fprintf('\n        = 3 ... STOP the DEMO. \n')
   CHOICE = input(' Enter ............................... CHOICE = ');
   if isempty(CHOICE); CHOICE = 1; end
   %
   if CHOICE == 1
      f1 = figure;
      set(f1, 'NumberTitle', 'off', 'Name', ...
              'Solution of:  u_{tt} - u_{xx} = 0.')
      whitebg(f1, 'k')
      axis([-1 1 0 2 0 1.5])
      hold on
      set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
      grid on
      xlabel('{\bf x}', 'FontSize', 20)
      ylabel('{\bf t}', 'FontSize', 20)
      zlabel('{\bf u}', 'FontSize', 20, 'Rotation', 0)
      title('{\bf Solution of:  u_{tt} - u_{xx} = 0.}', 'FontSize', 18)
      mesh(x, T, U)
      shading flat   % options are: faceted, interp, flat
      colormap(hsv)
      rotate3d on
      fprintf('\n Rotate 3D on. Use the mouse to rotate picture. \n')
   elseif CHOICE == 2
      f2 = figure;
      set(f1, 'NumberTitle', 'off', 'Name', ...
              'Slide show of solution u = u(x, t).')
      whitebg(f2, 'k')
      axis off
      text(0.5, 0.6, '{\bf Press any key to start.}', ...
           'FontSize',             24, ... 
           'Units',               'Normalized', ...
           'HorizontalAlignment', 'center')
      text(0.5, 0.4, '{\bf Press any key to change slides.}', ...
           'FontSize',             24, ... 
           'Units',               'Normalized', ...
           'HorizontalAlignment', 'center')
      pause
      axis on
      tt=0:0.1:2;
      for na=1:21
         n = 1;
         for nb=n:M
            if T(nb) <= tt(na)
               nn=nb;
            end
         end
         n = nn;
         plot(x, U(n,:), '-c', 'LineWidth', 3)
         hold on
         grid on
         set(gca, 'FontWeight', 'Bold', 'FontSize', 16)
         axis([-1 1 0 1])
         TIME = num2str(T(n));
         title(['{\bf Solution u = u(x, t) for t = ', TIME, '}'], ...
                'FontSize', 20)
         xlabel('{\bf x}', 'FontSize', 20)
         ylabel('{\bf u}', 'FontSize', 20, 'Rotation', 0)
         pause
         hold off
      end 
   end
end
fprintf('\n BYE!\n')
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-17-2001.
% Update     by Rodolfo R. Rosales  02-25-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
