function GBNS_lecture_SEL(Part)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture_SEL(Part)
%          Used by the Select button during 2D pictures
%          to set up the calculation to display.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
Hsl = global_GBNS_lect_FigPar.Hsl;
Hbt = global_GBNS_lect_FigPar.Hbt;
Hdp = global_GBNS_lect_FigPar.Hdp;
%
% --- PART 1 *****************************************************************
%
if strcmp(Part, 'Part 1')
   global global_GBNS_lect_Part_1
   Ncases = length(global_GBNS_lect_Part_1);
   %
   % --- Update UserData.
   %
   UserData = get(Hbt(2), 'UserData');
   UserData = UserData+1;
   if UserData > Ncases; UserData = 1; end
   set(Hbt(2), 'UserData', UserData)
   %
   % --- Get values needed to set display windows and slider.
   %
   n = UserData;
   N    = global_GBNS_lect_Part_1{n}.N;    % N    = [40 50 55 57 60 80].
   a    = global_GBNS_lect_Part_1{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_1{n}.t_f;  % t_f  = 2.
   M    = global_GBNS_lect_Part_1{n}.M;    % number of time slices.
   %
   % --- Set Slider
   %
   set(Hsl, ...
       'Min',          1, ...
       'Max',          M, ...
       'Value',        1, ...
       'SliderStep',   [1/(M-1)  0.1], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_2D(1)')
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 1/N')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 2/N')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',           ['N = ', num2str(N)])
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Bad"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Cosine')
   %
end
%
% --- PART 2 *****************************************************************
%
if strcmp(Part, 'Part 2')
   global global_GBNS_lect_Part_2
   Ncases = length(global_GBNS_lect_Part_2);
   %
   % --- Update UserData.
   %
   UserData = get(Hbt(2), 'UserData');
   UserData = UserData+1;
   if UserData > Ncases; UserData = 1; end
   set(Hbt(2), 'UserData', UserData)
   %
   % --- Get values needed to set display windows and slider.
   %
   n = UserData;
   N    = global_GBNS_lect_Part_2{n}.N;    % N    = 100.
   a    = global_GBNS_lect_Part_2{n}.a;    % a    = [15 10  7  6  5  4].
   t_f  = global_GBNS_lect_Part_2{n}.t_f;  % t_f  = 0.5.
   M    = global_GBNS_lect_Part_2{n}.M;    % number of time slices.
   %
   % --- Set Slider
   %
   set(Hsl, ...
       'Min',          1, ...
       'Max',          M, ...
       'Value',        1, ...
       'SliderStep',   [1/(M-1)  0.1], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_2D(2)')
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 0.01')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 0.02')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',           ['a = ', num2str(a)])
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Bad"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Gaussian')
   %
end
%
% --- PART 3 *****************************************************************
%
if strcmp(Part, 'Part 3')
   global global_GBNS_lect_Part_3
   Ncases = length(global_GBNS_lect_Part_3);
   %
   % --- Update UserData.
   %
   UserData = get(Hbt(2), 'UserData');
   UserData = UserData+1;
   if UserData > Ncases; UserData = 1; end
   set(Hbt(2), 'UserData', UserData)
   %
   % --- Get values needed to set display windows and slider.
   %
   n = UserData;
   N    = global_GBNS_lect_Part_3{n}.N;    % N    = [40 50 55 57 60 80 160].
   a    = global_GBNS_lect_Part_3{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_3{n}.t_f;  % t_f  = 2.
   M    = global_GBNS_lect_Part_3{n}.M;    % number of time slices.
   %
   % --- Set Slider
   %
   set(Hsl, ...
       'Min',          1, ...
       'Max',          M, ...
       'Value',        1, ...
       'SliderStep',   [1/(M-1)  0.1], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_2D(3)')
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 1/N')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 2/N')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',           ['N = ', num2str(N)])
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Good"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Cosine')
   %
end
%
GBNS_lecture_MSG3
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
