function Msg = GBNS_lecture_RESET
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Msg = GBNS_lecture_RESET
%      Reset control window to startup status.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'PDE numerical scheme stability.')
   set(global_GBNS_lect_FigPar.Hbt(1), ...
       'Enable',   'on', ...
       'String',   'Close', ...
       'CallBack', 'GBNS_lecture(''Close'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'Enable',   'on', ...
       'String',   'Part 3', ...
       'CallBack', 'GBNS_lecture(''Part 3'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'Enable',   'on', ...
       'String',   'Part 2', ...
       'CallBack', 'GBNS_lecture(''Part 2'')');
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'Enable',   'on', ...
       'String',   'Part 1', ...
       'CallBack', 'GBNS_lecture(''Part 1'')');
   set(global_GBNS_lect_FigPar.Hbt(5), ...
       'Enable',   'off', ...
       'String',   'Reset View', ...
       'CallBack', 'GBNS_lecture(''Reset View'')');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'Enable',   'off', ...
       'String',   'Rotate', ...
       'CallBack', 'GBNS_lecture(''Rotate'')');
   set(global_GBNS_lect_FigPar.Hbt(7), ...
       'Enable',   'on', ...
       'String',   'Help', ...
       'CallBack', 'GBNS_lecture(''Help'')');
   set(global_GBNS_lect_FigPar.Hsl,    'Enable', 'off')
   for n=1:7
       set(global_GBNS_lect_FigPar.Hdp(n), 'Visible', 'off')
   end
   GBNS_lecture_MSG1
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
