function Msg = GBNS_lecture_MSG3
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Msg = GBNS_lecture_MSG3
%      Displays the startup 2D message on the main screen for GNBS_lecture.
%      Msg (optional) has the handles for the various text objects.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
%
Hbt = global_GBNS_lect_FigPar.Hbt;
Hax = global_GBNS_lect_FigPar.Hax;
axes(Hax)
cla
rotate3d off
set(gca, 'Visible', 'off')
%
STRING = get(Hbt(4), 'String');
MainT  = ['2D pictures, Part ', STRING(1, 7)];
%
n = 1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.50, 1.05],  ...
     'HorizontalAlignment', 'center', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09, ....
     'String',               MainT);
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.50, 0.95],  ...
     'HorizontalAlignment', 'center', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09, ....
     'String',              'of the lecture.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.80],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Help:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.80],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push for lecture text.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.75],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Movie:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.75],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to see time evolution.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.70],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Reset View:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.70],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'NOT ACTIVE.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.65],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',               [STRING, ':']);
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.65],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to return to the');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.60],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'start of the lecture.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.55],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              '3D Figs:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.55],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to switch to 3D figures.');
% ---------------------------------------------------------

n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.55],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              '3D Figs:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.55],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to switch to 3D figures.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.50],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Select:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.50],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to move to next case');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.36, 0.45],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'within this part, as shown');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.36, 0.40],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'in the display windows.');

% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.35],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Close:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.35],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to end lecture.');

% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.30],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Slider:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.30],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Use it to move through the');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.25],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'pictures in this Part case.');
%
if nargout == 0; clear Msg; end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
