function Msg = GBNS_lecture_MSG2
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Msg = GBNS_lecture_MSG2
%      Displays the startup 3D message on the main screen for GNBS_lecture.
%      Msg (optional) has the handles for the various text objects.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
%
Hbt = global_GBNS_lect_FigPar.Hbt;
Hax = global_GBNS_lect_FigPar.Hax;
axes(Hax)
cla
rotate3d off
set(gca, 'Visible', 'off')
%
STRING = get(Hbt(4), 'String');
MainT  = ['3D pictures, Part ', STRING(1, 7)];
%
n = 1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.50, 1.05],  ...
     'HorizontalAlignment', 'center', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09, ....
     'String',               MainT);
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.50, 0.95],  ...
     'HorizontalAlignment', 'center', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09, ....
     'String',              'of the lecture.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.80],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Help:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.80],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push for lecture text.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.75],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Rotate:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.75],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push and MatLab will rotate');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.70],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              '3D pictures automatically.');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.65],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push again to stop.');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.60],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'You can also rotate 3D');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.55],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'pictures using the mouse.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.50],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Reset View:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.50],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to reset view after');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.45],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'rotating 3D pictures.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.40],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',               [STRING, ':']);
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.40],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to return to the');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.35],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'start of the lecture.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.30],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              '2D Figs:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.30],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to switch to 2D figures.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.25],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Close:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.25],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Push to end lecture.');
% ---------------------------------------------------------
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.00, 0.20],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Slider:');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.31, 0.20],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'Use it to move through the');
n = n+1;
Msg(n) = text(...
     'Units',               'Normalized', ...
     'Position',             [0.35, 0.15],  ...
     'HorizontalAlignment', 'left', ...
     'FontWeight',          'Bold', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.05, ....
     'String',              'pictures in this Part.');
%
if nargout == 0; clear Msg; end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
