function GBNS_lecture_HELP
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture_HELP
%          Displays help/text of lecture for GNBS_lecture.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
HelpTxT = [ ...
   '                                                                    '; ...
   ' Good/Bad Numerical Schemes Lecture.                                '; ...
   '                                                                    '; ...
   ' The lecture has the following parts:                               '; ...
   '                                                                    '; ...
   ' Part 1. The dangers of Naive numerical schemes:                    '; ...
   '         NUMERICAL INSTABILITIES.                                   '; ...
   '         Bad behavior with mesh refinement.                         '; ...
   ' Part 2. The dangers of Naive numerical schemes:                    '; ...
   '         NUMERICAL INSTABILITIES.                                   '; ...
   '         Bad behavior with loss of smoothness.                      '; ...
   ' Part 3. NUMERICAL INSTABILITIES.                                   '; ...
   '         Stabilization by dissipation.                              '; ...
   '                                                                    '; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '                                                                    '; ...
   ' Part 1. The dangers of Naive numerical schemes:                    '; ...
   '         NUMERICAL INSTABILITIES.                                   '; ...
   '         Bad behavior with mesh refinement.                         '; ...
   '                                                                    '; ...
   ' Consider the wave equation in 1-D:    u_tt = u_xx, for u(x, t).    '; ...
   ' Introducing v = u_t this yields: /     u_t = v     and             '; ...
   '                                  \     v_t = u_xx,                 '; ...
   ' which has the advantage of being written as a first order (in time)'; ...
   ' system. To do a numerical approximation, we replace the derivatives'; ...
   ' in the equation by finite differences (with dt and dx SMALL) to get'; ...
   ' (up to terms of O(dx^2, dt)):                                      '; ...
   '                                                                    '; ...
   '            {u(x,t+dt)-u(x,t)}/dt = v(x,t)                          '; ...
   ' and        {v(x,t+dt)-v(x,t)}/dt = u2(x,t),                        '; ...
   '                                                                    '; ...
   ' where          u2(x, t) = {u(x+dx,t)-2*u(x,t)+u(x-dx,t)}/(dx)^2    '; ...
   ' approximates u_xx(x, t).                                           '; ...
   '                                                                    '; ...
   ' Consider now a discrete grid    x_n = x_0 + n*dx   and   t_l = l*dt'; ...
   ' and evaluate the solution on it / u_n^l = u(x_n, t_l),             '; ...
   '                                 \ v_n^l = v(x_n, t_l).             '; ...
   '                                                                    '; ...
   ' The approximation above yields the solution at the time t = t_{l+1}'; ...
   ' once it is known at t = t_l. Thus it yields a numerical scheme that'; ...
   ' should give the solution with errors O(dx^2, dt) ...               '; ...
   '                                                                    '; ...
   '                           or WILL IT?                              '; ...
   '                                                                    '; ...
   ' The PURPOSE OF THIS PART is to check out this question.  We do this'; ...
   ' by using the scheme to do several calculations, as follows:        '; ...
   '                                                                    '; ...
   ' --- Use the interval -1 <= x < 1 (periodic boundary conditions.)   '; ...
   '                                                                    '; ...
   ' --- Use sinusoidal initial data:  u(x, 0) = 0.5*{1+cos(pi*x)},     '; ...
   '                                   v(x, 0) = 0,                     '; ...
   '                                                                    '; ...
   ' --- Compute over the time interval 0 <= t <= 2.0                   '; ...
   '                                                                    '; ...
   ' --- For the values N =  [40, 50, 55, 57, 60, 80], use the following'; ...
   '     space and time discretization:                                 '; ...
   '                                                                    '; ...
   '           x(n) = -1 + (n-1)*dx,  for n=1:N      and  dx = 2/N.     '; ...
   '           t(n) =  0 + (n-1)*dt,  for n=1:2*N+1  and  dt = 1/N.     '; ...
   '                                                                    '; ...
   ' The following is a summary of what happens when this is done.      '; ...
   ' USE THE Part 1 BUTTON and THE SLIDER to see the actual pictures.   '; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 40. Seems to work basically OK. ========================= '; ...
   '                                                                    '; ...
   ' With N = 40 points (in space) we obtain a rather reasonable looking'; ...
   ' solution ... though NOT QUITE RIGHT: The exact solution is periodic'; ...
   ' in time and reproduces the initial data at time t = 2.  But here we'; ...
   ' can see that the AMPLITUDE HAS GONE UP at t = 2 !!                 '; ...
   '                                                                    '; ...
   ' On the other hand: N is not too large, and we should not expect too'; ...
   ' much accuracy anyway. Thus, we expect that as N grows (so dt and dx'; ...
   ' get smaller) better approximations will be obtained. RIGHT???      '; ...
   '                                                                    '; ...
   ' Well: WRONG!  Making N larger makes the answer WORSE!              '; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 50. Note the small noise near x = 0 and t = 2. ========== '; ...
   '                                                                    '; ...
   ' With N = 50 points,  we end up with some small noise  (close to the'; ...
   ' maximum of the solution for t near 2.  Let us check what happens if'; ...
   ' we keep increasing N.                                              '; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 55. Noise gets BIGGER. ================================== '; ...
   '                                                                    '; ...
   ' With N = 55 points, the noise gets bigger and clearly visible.     '; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 57. Noise as big as the rest of the solution! =========== '; ...
   '                                                                    '; ...
   ' With N = 57, it starts to be hard to distinguish the noise from the'; ...
   ' solution.  By now it is quite clear that, as we decrease dx and dt,'; ...
   ' not only does the numerical solution fail to get better; in fact it'; ...
   ' GETS WORSE!                                                        '; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 60 Worsening trend continues. =========================== '; ...
   '                                                                    '; ...
   ' With N = 60, the noise completely dominates the numerical solution!'; ...
   '                                                                    '; ...
   ' ___________________________________________________________________'; ...
   ' CASE N = 80. DISASTER! =========================================== '; ...
   '                                                                    '; ...
   ' Finally, with N = 80, we have a complete DISASTER! The noise is now'; ...
   ' of a HUGE amplitude, of order 10^7!    For still larger values of N'; ...
   ' this disaster gets EXPONENTIALLY worse!                            '; ...
   '                                                                    '; ...
   ' Notice  (in the plot of the solution for time t = 2)  how the noise'; ...
   ' is actually made up of very large amplitude oscillations, that have'; ...
   ' a wavelength of two grid spacings.   That is, in the numerical grid'; ...
   ' they show up as an alternating up and down in the solution.        '; ...
   '                                                                    '; ...
   '                                                                    '; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '                                                                    '; ...
   ' Part 2. The dangers of Naive numerical schemes:                    '; ...
   '         NUMERICAL INSTABILITIES.                                   '; ...
   '         Bad behavior with loss of smoothness.                      '; ...
   '                                                                    '; ...
   ' We now carry a different test (of the naive algorithm introduced in'; ...
   ' PART I).  Instead of changing dx,  we will keep dx fixed and change'; ...
   ' the initial conditions.       Specifically, we still compute in the'; ...
   ' interval -1 < x < 1, with periodic boundary conditions, but use for'; ...
   ' the initial data a GAUSSIAN profile                                '; ...
   '                     u(x, 0) = exp(-a*log(10)*x^2)                  '; ...
   '              and    v(x, 0) = 0,                                   '; ...
   '              for various values of a = [15, 10, 7, 6, 5, 4].       '; ...
   ' We use N = 100 points in the interval, with dx = 2/N,              '; ...
   '                                             dt = dx/2              '; ...
   ' and compute for 0 < t < 0.5.                                       '; ...
   '                                                                    '; ...
   ' The Gaussian profile above is not periodic --- as was the case with'; ...
   ' the cosine in PART I.        Thus, the periodic boundary conditions'; ...
   ' introduce a corner in the initial data, at the ends x = +/-1 of the'; ...
   ' interval.   This corner gets "sharper" as "a" decreases, since then'; ...
   ' the Gaussian is less and less "flat" near the ends of the interval.'; ...
   '                                                                    '; ...
   ' What the numerical computations show is that: these corners trigger'; ...
   ' the same phenomena we observed in PART I:   Grid scale oscillations'; ...
   ' that get bigger as "a" decreases (sharper corner.)                 '; ...
   '                                                                    '; ...
   ' Oscillations are first noticeable for a = 7 near (x,t) = (-1, 0.5) '; ...
   ' """""""""""" are big              """ a = 5,                       '; ...
   ' """""""""""" are huge             """ a = 4.                       '; ...
   '                                                                    '; ...
   '                                                                    '; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '********************************************************************'; ...
   '                                                                    '; ...
   ' Part 3. NUMERICAL INSTABILITIES.                                   '; ...
   '         Stabilization by dissipation.                              '; ...
   '                                                                    '; ...
   ' The problem is that: the naive scheme introduced in PART I fails to'; ...
   ' be stable.   This can be shown via a von Neumann stability analysis'; ...
   ' of the scheme.    This analysis shows that all the scheme solutions'; ...
   ' blow up exponentially, the faster the shorter the wavelength  (this'; ...
   ' explains why, in our calculations, the solutions ended up dominated'; ...
   ' by grid scale oscillations.                                        '; ...
   '                                                                    '; ...
   ' One simple way to fix the problem is to add                        '; ...
   '                     "numerical viscosity"                          '; ...
   ' to the scheme. This will kill oscillations, the fastest the shorter'; ...
   ' the wavelength.   Thus one can "tune-up" this viscosity so that the'; ...
   ' scheme behaves properly.    The scheme below is an example of using'; ...
   ' this technique on the naive scheme we have been using so far:      '; ...
   '                                                                    '; ...
   '        u(x,t+dt) = u(x,t) +  v(x,t)*dt + u2(x,t)*eta,              '; ...
   '        v(x,t+dt) = v(x,t) + u2(x,t)*nu + v2(x,t)*eta,              '; ...
   '                                                                    '; ...
   ' where nu = dt/(dx)^2 and eta = (dt/dx)^2  (u2 and v2 are as defined'; ...
   ' in PART I. This scheme is stable if dt <= 0.5*dx.                  '; ...
   '                                                                    '; ...
   ' NOTE: a) This scheme works, but it is far from being "best around".'; ...
   '          We introduce it here just as an illustration.             '; ...
   '       b) For more information on these two schemes, the von Neumann'; ...
   '          stability analysis, etc., see the notes:                  '; ...
   '                        18311 WEB page                              '; ...
   '               "Stability of Numerical Schemes for PDE_s".          '; ...
   '       c) A good book to check is:   "Numerical Recipies", by Press,'; ...
   '          Teukolsky, Vetterling and Flannery, Cambridge U. Press.   '; ...
   '                                                                    '; ...
   ' Using the control window you can see the result of carrying exactly'; ...
   ' the same calculations as in PART I,   but with the new scheme.  The'; ...
   ' most IMPORTANT thing to notice is that:  there are NO OSCILLATIONS.'; ...
   '                                                                    '; ...
   ' A second point is that at t = 2 the initial data are not reproduced'; ...
   ' (as they are for the exact solution.)     However, instead of being'; ...
   ' amplified (as the first scheme does),  they are DAMPED --- with the'; ...
   ' amount of damping going down as dx decreases.    This is due to the'; ...
   ' added numerical dissipation.                                       '; ...
   '                                                                    '; ...
   ' THE LAST figure (N = 160) shows how, with enough points, we can get'; ...
   ' pretty close to the right answer.   But, as commented above in (a),'; ...
   ' this scheme is not too hot.  A good scheme could have achieved this'; ...
   ' same result with far less points!                                  '; ...
   '                                                                    '; ...
   '                                                                    '];
%
helpwin(HelpTxT, 'Numerical Schemes.')
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
