function OUTPUT = GBNS_lecture_Compute(Part)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function OUTPUT = GBNS_lecture_Compute
%          Computes solutions used by the GNBS_lecture.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
% OUTPUT IS A CELL ARRAY/STRUCTURE WITH THE FIELDS.
%
% If Part = 1 (for n=1:6) we have:
%       OUTPUT{n}.N ................ value of   N = [40 50 55 57 60 80].
%       OUTPUT{n}.a ................ value of   a = 1.
%       OUTPUT{n}.t_f .............. value of t_f = 2.
%       OUTPUT{n}.x ................ space mesh in [-1 1], dx = 2/N;
%       OUTPUT{n}.T ................ computed times M by 1 array
%       OUTPUT{n}.U ................ computed u     M by N array
%       OUTPUT{n}.V ................ computed v     M by N array
%       OUTPUT{n}.M ................ number of time slices.
%       OUTPUT{n}.umin ............. value of u to use as minimum for axes.
%       OUTPUT{n}.umax ............. value of u to use as maximum for axes.
%       --- Use BAD scheme and COSINE initial conditions.
%
% If Part = 2 (for n=1:6) we have:
%       OUTPUT{n}.N ................ value of   N = 100.
%       OUTPUT{n}.a ................ value of   a = [15 10  7  6  5  4].
%       OUTPUT{n}.t_f .............. value of t_f = 0.5.
%       OUTPUT{n}.x ................ space mesh in [-1 1], dx = 2/N;
%       OUTPUT{n}.T ................ computed times M by 1 array
%       OUTPUT{n}.U ................ computed u     M by N array
%       OUTPUT{n}.V ................ computed v     M by N array
%       OUTPUT{n}.M ................ number of time slices.
%       OUTPUT{n}.umin ............. value of u to use as minimum for axes.
%       OUTPUT{n}.umax ............. value of u to use as maximum for axes.
%       --- Use BAD scheme and COSINE initial conditions.
%
% If Part = 3 (for n=1:7) we have:
%       OUTPUT{n}.N ................ value of   N = [40 50 55 57 60 80 160].
%       OUTPUT{n}.a ................ value of   a = 1.
%       OUTPUT{n}.t_f .............. value of t_f = 2.
%       OUTPUT{n}.x ................ space mesh in [-1 1], dx = 2/N;
%       OUTPUT{n}.T ................ computed times M by 1 array
%       OUTPUT{n}.U ................ computed u     M by N array
%       OUTPUT{n}.V ................ computed v     M by N array
%       OUTPUT{n}.M ................ number of time slices.
%       OUTPUT{n}.umin ............. value of u to use as minimum for axes.
%       OUTPUT{n}.umax ............. value of u to use as maximum for axes.
%       --- Use GOOD scheme and COSINE initial conditions.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ____________________________________________________________________________
% Computations for Part 1. ***************************************************
% --- Cosine initial condition, bad scheme.
% --- One period in space (a = 1) and time (t_f = 2).
% --- Change N.
%
if strcmp(Part, 'Part 1')
   a   = 1;
   t_f = 2;
   N   = [40, 50, 55, 57, 60, 80];
   for n=1:length(N)
      [x, T, U, V, M] = InitGBNS(N(n), a, t_f, 'C', 'B');
      umin = floor(11*min(min(U)))/10;
      umax =  ceil(11*max(max(U)))/10;
      OUTPUT{n}.N    = N(n);
      OUTPUT{n}.a    = a;
      OUTPUT{n}.t_f  = t_f;
      OUTPUT{n}.x    = x;
      OUTPUT{n}.T    = T;
      OUTPUT{n}.U    = U;
      OUTPUT{n}.V    = V;
      OUTPUT{n}.M    = M;
      OUTPUT{n}.umin = umin;
      OUTPUT{n}.umax = umax;
   end
end
%
% ____________________________________________________________________________
% Computations for Part 2. ***************************************************
% --- Gaussian initial condition, bad scheme.
% --- Fixed N = 100 and t_f = 0.5. One period in space.
% --- Change a.
%
if strcmp(Part, 'Part 2')
   a   = [15, 10, 7, 6, 5, 4];
   t_f = 0.5;
   N   = 100;
   for n=1:length(a)
      [x, T, U, V, M] = InitGBNS(N, a(n), t_f, 'G', 'B');
      umin = floor(11*min(min(U)))/10;
      umax =  ceil(11*max(max(U)))/10;
      OUTPUT{n}.N    = N;
      OUTPUT{n}.a    = a(n);
      OUTPUT{n}.t_f  = t_f;
      OUTPUT{n}.x    = x;
      OUTPUT{n}.T    = T;
      OUTPUT{n}.U    = U;
      OUTPUT{n}.V    = V;
      OUTPUT{n}.M    = M;
      OUTPUT{n}.umin = umin;
      OUTPUT{n}.umax = umax;
   end
end
%
% ____________________________________________________________________________
% Computations for Part 3. ***************************************************
% --- Cosine initial condition, good scheme.
% --- One period in space (a = 1) and time (t_f = 2).
% --- Change N.
%
if strcmp(Part, 'Part 3')
   a   = 1;
   t_f = 2;
   N   = [40, 50, 55, 57, 60, 80, 160];
   for n=1:length(N)
      [x, T, U, V, M] = InitGBNS(N(n), a, t_f, 'C', 'G');
      umin = floor(11*min(min(U)))/10;
      umax =  ceil(11*max(max(U)))/10;
      OUTPUT{n}.N    = N(n);
      OUTPUT{n}.a    = a;
      OUTPUT{n}.t_f  = t_f;
      OUTPUT{n}.x    = x;
      OUTPUT{n}.T    = T;
      OUTPUT{n}.U    = U;
      OUTPUT{n}.V    = V;
      OUTPUT{n}.M    = M;
      OUTPUT{n}.umin = umin;
      OUTPUT{n}.umax = umax;
   end
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
