function GBNS_lecture_3D(Part, First)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture_3D(Part, First)
%      Set control window to display 3D pictures.
%      First = 1 ... setup time, load values on slider, etc.
%      First = 0 ... calls by slider.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
Hsl = global_GBNS_lect_FigPar.Hsl;
Hbt = global_GBNS_lect_FigPar.Hbt;
Hdp = global_GBNS_lect_FigPar.Hdp;
Hax = global_GBNS_lect_FigPar.Hax;
%
% --- PART 1 *****************************************************************
%
if (Part == 1) & (First == 1)
   set(Hsl, ...
       'Min',          1, ...
       'Max',          7, ...
       'Value',        1, ...
       'SliderStep',   [1/6  1/3], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_3D(1, 0)')
   axes(Hax)
   colormap(hsv)
   GBNS_lecture_MSG2
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 1/N')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 2/N')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'N = ?')
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Bad"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Cosine')
   %
end
%
if  (Part == 1) & (First == 0)
   global global_GBNS_lect_Part_1
   val = round(get(Hsl, 'Value'));
   set(Hsl, 'Value', val)
   n = min(val, 6);
   N    = global_GBNS_lect_Part_1{n}.N;    % N    = [40 50 55 57 60 80].
   a    = global_GBNS_lect_Part_1{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_1{n}.t_f;  % t_f  = 2.
   x    = global_GBNS_lect_Part_1{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_1{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_1{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_1{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_1{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_1{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_1{n}.umax; % u maximum for axes.
   %
   axes(Hax)
   cla
   if val < 7
      axis([-1 1 0 t_f umin umax])
      set(Hax, 'Visible',    'on', ...
               'FontUnits',  'Normalized', ...
               'FontWeight', 'Bold', ...
               'FontSize',    0.05, ...
               'LineWidth',   1)
      hold on
      grid on
      rotate3d on
      %
      mesh(x, T, U)
      view(-37.5, 30)
      shading flat   % options are: faceted, interp, flat
      NRES = num2str(N);
      title(['{\bf u = u(x, t) with N = ', NRES, ' points.}'], ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      xlabel('{\bf x}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      ylabel('{\bf t}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      zlabel('{\bf u}', ...
             'HorizontalAlignment', 'right', ...
             'Rotation',              0, ...
             'FontUnits',            'Normalized', ...
             'FontSize',              0.07)
      hold off
      %
      % --- Set reset view button.
      %
      set(Hbt(5), ...
             'Enable',   'on', ...
             'CallBack', 'view(-37.5, 30)')
      %
      % --- Set rotate button.
      %
      set(Hbt(6), ...
             'Enable',        'on', ...
             'Interruptible', 'on', ...
             'UserData',      'play')
      %
      % --- Set Displays:
      %
      set(Hdp(1), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dt = 1/N')
      set(Hdp(2), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dx = 2/N')
      set(Hdp(3), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',           ['N = ', NRES])
      set(Hdp(4), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          'scheme')
      set(Hdp(5), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          '"Bad"')
      set(Hdp(6), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'k', ...
             'String',          'initial data')
      set(Hdp(7), ...
             'ForeGroundColor', 'k', ...
             'Visible',         'on', ...
             'String',          'Cosine')
      %
   end
   if val == 7
      axis([-1 1 umin umax])
      set(Hax, 'Visible',    'on', ...
               'FontUnits',  'Normalized', ...
               'FontWeight', 'Bold', ...
               'FontSize',    0.05, ...
               'LineWidth',   1)
      hold on
      grid on
      rotate3d off
      %
      plot(x, U(M, :), '-c', 'LineWidth', 2)
      NRES = num2str(N);
      title(['{\bf u = u(x, 2),  N = ', NRES, '.}'], ...
             'FontUnits', 'Normalized', ...
             'FontSize',   0.07)
      xlabel('{\bf x}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',   0.07)
      ylabel('{\bf u}', ...
             'HorizontalAlignment', 'right', ...
             'Rotation',             0, ...
             'FontUnits',           'Normalized', ...
             'FontSize',             0.07)
      hold off
      %
      % --- Set reset view and rotate buttons.
      %
      set(Hbt(5), 'Enable',   'off')
      set(Hbt(6), 'Enable',   'off')
      %
      % --- Set Displays:
      %
      set(Hdp(1), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dt = 1/N')
      set(Hdp(2), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dx = 2/N')
      set(Hdp(3), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',           ['N = ', NRES])
      set(Hdp(4), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          'scheme')
      set(Hdp(5), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          '"Bad"')
      set(Hdp(6), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'k', ...
             'String',          'initial data')
      set(Hdp(7), ...
             'ForeGroundColor', 'k', ...
             'Visible',         'on', ...
             'String',          'Cosine')
      %
   end
end
%
% --- PART 2 *****************************************************************
%
if (Part == 2) & (First == 1)
   set(Hsl, ...
       'Min',          1, ...
       'Max',          7, ...
       'Value',        1, ...
       'SliderStep',   [1/6  2/6], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_3D(2, 0)')
   axes(Hax)
   colormap(hsv)
   GBNS_lecture_MSG2
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 0.01')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 0.02')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'a = ?')
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Bad"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Gaussian')
   %
end
%
if  (Part == 2) & (First == 0)
   global global_GBNS_lect_Part_2
   val = round(get(Hsl, 'Value'));
   set(Hsl, 'Value', val)
   n = min(val, 6);
   N    = global_GBNS_lect_Part_2{n}.N;    % N    = 100.
   a    = global_GBNS_lect_Part_2{n}.a;    % a    = [15 10  7  6  5  4].
   t_f  = global_GBNS_lect_Part_2{n}.t_f;  % t_f  = 0.5.
   x    = global_GBNS_lect_Part_2{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_2{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_2{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_2{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_2{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_2{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_2{n}.umax; % u maximum for axes.
   %
   axes(Hax)
   cla
   if val < 7
      axis([-1 1 0 t_f umin umax])
      set(Hax, 'Visible',    'on', ...
               'FontUnits',  'Normalized', ...
               'FontWeight', 'Bold', ...
               'FontSize',    0.05, ...
               'LineWidth',   1)
      hold on
      grid on
      rotate3d on
      %
      mesh(x, T, U)
      view(-37.5, 30)
      shading flat   % options are: faceted, interp, flat
      NRES = num2str(a);
      title(['{\bf u = u(x, t) with a = ', NRES, '}'], ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      xlabel('{\bf x}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      ylabel('{\bf t}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',  0.07)
      zlabel('{\bf u}', ...
             'HorizontalAlignment', 'right', ...
             'Rotation',              0, ...
             'FontUnits',            'Normalized', ...
             'FontSize',              0.07)
      hold off
      %
      % --- Set reset view button.
      %
      set(Hbt(5), ...
             'Enable',   'on', ...
             'CallBack', 'view(-37.5, 30)')
      %
      % --- Set rotate button.
      %
      set(Hbt(6), ...
             'Enable',        'on', ...
             'Interruptible', 'on', ...
             'UserData',      'play')
      %
      % --- Set Displays:
      %
      set(Hdp(1), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dt = 0.01')
      set(Hdp(2), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dx = 0.02')
      set(Hdp(3), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',           ['a = ', NRES])
      set(Hdp(4), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          'scheme')
      set(Hdp(5), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          '"Bad"')
      set(Hdp(6), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'k', ...
             'String',          'initial data')
      set(Hdp(7), ...
             'ForeGroundColor', 'k', ...
             'Visible',         'on', ...
             'String',          'Gaussian')
      %
   end
   if val == 7
      axis([-1 1 umin umax])
      set(Hax, 'Visible',    'on', ...
               'FontUnits',  'Normalized', ...
               'FontWeight', 'Bold', ...
               'FontSize',    0.05, ...
               'LineWidth',   1)
      hold on
      grid on
      rotate3d off
      %
      plot(x, U(M, :), '-c', 'LineWidth', 2)
      NRES = num2str(a);
      title(['{\bf u = u(x, 0.5),  a = ', NRES, '}'], ...
             'FontUnits', 'Normalized', ...
             'FontSize',   0.07)
      xlabel('{\bf x}', ...
             'FontUnits', 'Normalized', ...
             'FontSize',   0.07)
      ylabel('{\bf u}', ...
             'HorizontalAlignment', 'right', ...
             'Rotation',             0, ...
             'FontUnits',           'Normalized', ...
             'FontSize',             0.07)
      hold off
      %
      % --- Set reset view and rotate buttons.
      %
      set(Hbt(5), 'Enable',   'off')
      set(Hbt(6), 'Enable',   'off')
      %
      % --- Set Displays:
      %
      set(Hdp(1), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dt = 0.01')
      set(Hdp(2), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',          'dx = 0.02')
      set(Hdp(3), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'b', ...
             'String',           ['a = ', NRES])
     set(Hdp(4), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          'scheme')
     set(Hdp(5), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'r', ...
             'String',          '"Bad"')
     set(Hdp(6), ...
             'Visible',         'on', ...
             'ForeGroundColor', 'k', ...
             'String',          'initial data')
     set(Hdp(7), ...
             'ForeGroundColor', 'k', ...
             'Visible',         'on', ...
             'String',          'Gaussian')
     %
   end
end
%
% --- PART 3 *****************************************************************
%
if (Part == 3) & (First == 1)
   set(Hsl, ...
       'Min',          1, ...
       'Max',          7, ...
       'Value',        1, ...
       'SliderStep',   [1/6  1/3], ...
       'Enable',      'on', ...
       'CallBack',    'GBNS_lecture_3D(3, 0)')
   axes(Hax)
   colormap(hsv)
   GBNS_lecture_MSG2
   %
   % --- Set Displays.
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 1/N')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 2/N')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'N = ?')
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Good"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Cosine')
   %
end
%
if  (Part == 3) & (First == 0)
   global global_GBNS_lect_Part_3
   val = round(get(Hsl, 'Value'));
   set(Hsl, 'Value', val)
   n = val;
   N    = global_GBNS_lect_Part_3{n}.N;    % N    = [40 50 55 57 60 80 160].
   a    = global_GBNS_lect_Part_3{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_3{n}.t_f;  % t_f  = 2.
   x    = global_GBNS_lect_Part_3{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_3{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_3{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_3{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_3{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_3{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_3{n}.umax; % u maximum for axes.
   %
   axes(Hax)
   cla
   axis([-1 1 0 t_f umin umax])
   set(Hax, 'Visible',    'on', ...
            'FontUnits',  'Normalized', ...
            'FontWeight', 'Bold', ...
            'FontSize',    0.05, ...
            'LineWidth',   1)
   hold on
   grid on
   rotate3d on
   %
   mesh(x, T, U)
   view(-37.5, 30)
   shading flat   % options are: faceted, interp, flat
   NRES = num2str(N);
   title(['{\bf u = u(x, t) with N = ', NRES, ' points.}'], ...
          'FontUnits', 'Normalized', ...
          'FontSize',  0.07)
   xlabel('{\bf x}', ...
          'FontUnits', 'Normalized', ...
          'FontSize',  0.07)
   ylabel('{\bf t}', ...
          'FontUnits', 'Normalized', ...
          'FontSize',  0.07)
   zlabel('{\bf u}', ...
          'HorizontalAlignment', 'right', ...
          'Rotation',              0, ...
          'FontUnits',            'Normalized', ...
          'FontSize',              0.07)
   hold off
   %
   % --- Set reset view button.
   %
   set(Hbt(5), ...
          'Enable',   'on', ...
          'CallBack', 'view(-37.5, 30)')
   %
   % --- Set rotate button.
   %
   set(Hbt(6), ...
          'Enable',        'on', ...
          'Interruptible', 'on', ...
          'UserData',      'play')
   %
   % --- Set Displays:
   %
   set(Hdp(1), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dt = 1/N')
   set(Hdp(2), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',          'dx = 2/N')
   set(Hdp(3), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'b', ...
          'String',           ['N = ', NRES])
   set(Hdp(4), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          'scheme')
   set(Hdp(5), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'r', ...
          'String',          '"Good"')
   set(Hdp(6), ...
          'Visible',         'on', ...
          'ForeGroundColor', 'k', ...
          'String',          'initial data')
   set(Hdp(7), ...
          'ForeGroundColor', 'k', ...
          'Visible',         'on', ...
          'String',          'Cosine')
   %
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
