function GBNS_lecture(STRING)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% Demo containing a "lecture" on numerical stability of schemes for PDE's.
% Has the following parts:
%
% Part 1. The dangers of Naive numerical schemes:
%         NUMERICAL INSTABILITIES.
%         Bad behavior with mesh refinement.
% Part 2. The dangers of Naive numerical schemes:
%         NUMERICAL INSTABILITIES.
%         Bad behavior with loss of smoothness.
% Part 3. NUMERICAL INSTABILITIES.
%         Stabilization by dissipation.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
global global_GBNS_lect_Part_1
global global_GBNS_lect_Part_2
global global_GBNS_lect_Part_3
%
if nargin == 0
   if isfield(global_GBNS_lect_FigPar, 'fgN')
      fgN = global_GBNS_lect_FigPar.fgN;
      if 1 == Exist_Figure_GBNS(fgN)
         close(fgN)
      end
   end
   global_GBNS_lect_FigPar = GBNS_lecture_FIG;
   FLAG_COMP = 0;
   %
   if isempty(global_GBNS_lect_Part_1)
      fprintf('\n Computing Part 1.')
      global_GBNS_lect_Part_1 = GBNS_lecture_Compute('Part 1');
      FLAG_COMP = 1;
   end
   %
   if isempty(global_GBNS_lect_Part_2)
      fprintf('\n Computing Part 2.')
      global_GBNS_lect_Part_2 = GBNS_lecture_Compute('Part 2');
      FLAG_COMP = 1;
   end
   %
   if isempty(global_GBNS_lect_Part_3)
      fprintf('\n Computing Part 3.')
      global_GBNS_lect_Part_3 = GBNS_lecture_Compute('Part 3');
      FLAG_COMP = 1;
   end
   %
   if FLAG_COMP == 1; fprintf('\n Ready. \n'); end
%
% ****************************************************************************
% --- Help Button.
elseif strcmp(STRING, 'Help')
   GBNS_lecture_HELP
%
% ****************************************************************************
% --- Part 1 Button.
elseif strcmp(STRING, 'Part 1')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 1: 3D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P1', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '2D Figs', ...
       'CallBack', 'GBNS_lecture(''2D Part 1'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   '', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Rotate', ...
       'CallBack', 'GBNS_lecture(''Rotate'')', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_3D(1, 1)
%
% ****************************************************************************
% --- 2D figures for Part 1 Button.
elseif strcmp(STRING, '2D Part 1')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 1: 2D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P1', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '3D Figs', ...
       'CallBack', 'GBNS_lecture(''Part 1'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   'Select', ...
       'CallBack', 'GBNS_lecture_SEL(''Part 1'')', ...
       'UserData',  0, ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Movie', ...
       'CallBack', 'GBNS_lecture_Movie', ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_SEL('Part 1')
%
% ****************************************************************************
% --- Part 2 Button.
elseif strcmp(STRING, 'Part 2')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 2: 3D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P2', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '2D Figs', ...
       'CallBack', 'GBNS_lecture(''2D Part 2'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   '', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Rotate', ...
       'CallBack', 'GBNS_lecture(''Rotate'')', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_3D(2, 1)
%
% ****************************************************************************
% --- 2D figures for Part 2 Button.
elseif strcmp(STRING, '2D Part 2')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 2: 2D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P2', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '3D Figs', ...
       'CallBack', 'GBNS_lecture(''Part 2'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   'Select', ...
       'CallBack', 'GBNS_lecture_SEL(''Part 2'')', ...
       'UserData',  0, ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Movie', ...
       'CallBack', 'GBNS_lecture_Movie', ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_SEL('Part 2')
%
% ****************************************************************************
% --- Part 3 Button.
elseif strcmp(STRING, 'Part 3')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 3: 3D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P3', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '2D Figs', ...
       'CallBack', 'GBNS_lecture(''2D Part 3'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   '', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Rotate', ...
       'CallBack', 'GBNS_lecture(''Rotate'')', ...
       'Enable',   'off');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_3D(3, 1)
%
% ****************************************************************************
% --- 2D figures for Part 3 Button.
elseif strcmp(STRING, '2D Part 3')
   set(global_GBNS_lect_FigPar.fgN, ...
       'Name', 'Lecture, Part 3: 2D pictures.')
   set(global_GBNS_lect_FigPar.Hbt(4), ...
       'String',   'Quit P3', ...
       'CallBack', 'GBNS_lecture(''Reset'')');
   set(global_GBNS_lect_FigPar.Hbt(3), ...
       'String',   '3D Figs', ...
       'CallBack', 'GBNS_lecture(''Part 3'')');
   set(global_GBNS_lect_FigPar.Hbt(2), ...
       'String',   'Select', ...
       'CallBack', 'GBNS_lecture_SEL(''Part 3'')', ...
       'UserData',  0, ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'String',   'Movie', ...
       'CallBack', 'GBNS_lecture_Movie', ...
       'Enable',   'on');
   set(global_GBNS_lect_FigPar.Hbt(5), 'Enable',   'off');
   GBNS_lecture_SEL('Part 3')
%
% ****************************************************************************
% --- Rotate Button.
elseif strcmp(STRING, 'Rotate')
   for n=1:7
      EnableStatus.B{n} = get(global_GBNS_lect_FigPar.Hbt(n), 'Enable');
      set(global_GBNS_lect_FigPar.Hbt(n), 'Enable', 'off')
   end
   EnableStatus.S = get(global_GBNS_lect_FigPar.Hsl, 'Enable');
   set(global_GBNS_lect_FigPar.Hsl, 'Enable', 'off')
   %
   global_GBNS_lect_FigPar.EnableStatus = EnableStatus;
   %
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'Enable',   'on', ...
       'String',   'Stop', ...
       'CallBack', 'GBNS_lecture(''StopRotation'')');
   axes(global_GBNS_lect_FigPar.Hax)
   %
   Play = 'play';
   EL   = 30;
   AZ   = -37.5;
   DZ   = 10;
   while strcmp(Play, 'play')
      Play = get(global_GBNS_lect_FigPar.Hbt(6), 'UserData');
      AZ = (AZ + DZ) - 360*floor((AZ+DZ+37.5)/360);
      view(AZ, EL)
      drawnow
   end
   set(global_GBNS_lect_FigPar.Hbt(6), 'UserData', 'play')
%
% ****************************************************************************
% --- Stop Rotation Button.
elseif strcmp(STRING, 'StopRotation')
   set(global_GBNS_lect_FigPar.Hbt(6), ...
       'Enable',   'on', ...
       'String',   'Rotate', ...
       'UserData', 'Stop', ...
       'CallBack', 'GBNS_lecture(''Rotate'')');
   EnableStatus = global_GBNS_lect_FigPar.EnableStatus;
   for n=1:7
      set(global_GBNS_lect_FigPar.Hbt(n), 'Enable', EnableStatus.B{n});
   end
   set(global_GBNS_lect_FigPar.Hsl, 'Enable', EnableStatus.S);
%
% ****************************************************************************
% --- Close Button.
elseif strcmp(STRING, 'Close')
   delete(global_GBNS_lect_FigPar.fgN)
   clear global global_GBNS_lect_FigPar
   clear global global_GBNS_lect_Part_1
   clear global global_GBNS_lect_Part_2
   clear global global_GBNS_lect_Part_3
%
% ****************************************************************************
% --- Reset script to startup settings:
% 
elseif strcmp(STRING, 'Reset')
   GBNS_lecture_RESET
%
% ****************************************************************************
% --- End of options.
%
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function flag = Exist_Figure_GBNS(Fhandle)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function flag = Exist_Figure_GBNS(Fhandle)
%
% flag = 1 if figure with handle Fhandle is     currently displayed on screen.
% flag = 0 if """"""""""""""""""""""""""""" NOT """""""""""""""""""""""""""""
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fighdl = [];
hdlchi = get(0, 'Children');
for n = 1:length(hdlchi)
   if strcmp(get(hdlchi(n), 'type'), 'figure')
      fighdl = [fighdl; hdlchi(n)];
   end
end
fighdl = sort(fighdl);
flag = 0;
if ~isempty(fighdl)
   flag = max(fighdl == Fhandle);
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF

