function Output = demoWBRch_v03_MakeFig(Input)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Output = demoWBRch_v03_MakeFig(Input)
% .................................................... Rosales, Sept. 2008.
% Set-up a "nice" Figure Window on the screen, with a slider.
% SAME AS MakeFig311_v01
%
% Note that MakeFig311_v00 is the same as PSFGS_MakeFig_v02.
%
%           MakeFig311_v01 is the same as PSFGS_MakeFig_v03.
%
%           EXCEPT THAT: IN MakeFig311_v01 the EXTRA Input FIELD
%
%               Input.Vsbl = 'on' or 'off' (DEFAULT = 'on')
%
%           is allowed (to control the visibility of the figure).
% _________________________________________________________________________
%
% Modifications from PSFGS_MakeFig_v00 to PSFGS_MakeFig_v01:
%     Input name changes: sizeX      to  fW      Width  of figure
%                         sizeY      to  fH      Height of figure
%                         OverTitle  to  OvTitl  Text for over title.
%                         FontSize   to  FontSz  Font size for over title.
%     New inputs: aW ..... Plotting area width.
%                 aH ..... Plotting area height.
%
% Modifications from PSFGS_MakeFig_v01 to PSFGS_MakeFig_v02:
%                NOTE: PSFGS_MakeFig_v02 is the same as MakeFig311_v00,
%                      in the 18311_Toolkit:Support folder.
%     Move to the use of structures for input and output.   This allows
%     more options;  while, at the same time, keeping great flexibility
%     in terms of which options to modify from the defaults.   In fact,
%     it becomes easier to use: one can call the script with any set of
%     options activated (even none at all),  with the rest taking their
%     default values.
%     NEW OUTPUTS: a ... Axis handle.
%                  o ... Over title text handle (if over title exists.)
%                  s ... Slider handle (if slider exists.)
%     NEW INPUTS:  Allows the inclusion of a slider in the figure.
%                  The slider is controlled by the inputs:
%                  Slid, SldH, valu, maxi, mini, step, and cbck.
%
% Modifications from PSFGS_MakeFig_v02 to PSFGS_MakeFig_v03:
%                NOTE: PSFGS_MakeFig_v03 is the same as MakeFig311_v01,
%                      in the 18311_Toolkit:Support folder.
%     Set the properties: 
%                        PaperPosition
%                        PaperPositionMode
%     so that the saved figure lands in the middle of the page, with the
%     same shape specified by the figure properties.  NOTE: so that font
%     sizes are not screwed up and keep their relative sizes,  determine
%     them using normalized FontUnits. <<<<<<<<<<<<<<<< IMPORTANT !!!!!!
%
% _________________________________________________________________________
%
% OUTPUT ...... Output is an (optional) structure with the fields:
%
% f ........... Figure handle.
% a ........... Axis handle.
% o ........... Over title text handle (if over title exists.)
% s ........... Slider handle (if slider exists.)
%
% INPUT ....... Input is an (optional) structure with the (optional)
%               fields:
%
% Name ....... String with figure name on menu bar.
%              DEFAULT = 'PSFGS_MakeFig_v02'
% OvTi ....... String with "Over Title" (goes over the axis title.)
%              DEFAULT = not a field
% Slid ....... Flag. If Slid = 1, a slider is made at the bottom.
%                       Slid = 0, a slider is NOT made at the bottom.
%              DEFAULT = 0
% dX ......... Distance of the figure window from the right edge of screen,
%              in fractions of the screen minimum length.
%              DEFAULT = 0.04
% dY ......... Distance of the figure window from the top   edge of screen,
%              in fractions of the screen minimum length.
%              DEFAULT = 0.06
% fW ......... Figure window width,
%              in fractions of the screen minimum length.
%              DEFAULT = 0.70
% fH ......... Figure window height.
%              in fractions of the screen minimum length.
%              DEFAULT = 0.50
% aW ......... Plotting area width,  in fractions of fW.
%              DEFAULT = 0.75
% aH ......(*) Plotting area height, in fractions of fH.
%              DEFAULT = 0.75
% FtSz ....(*) Font size used in OverTitle, given in FRACTIONS OF fH.
%              DEFAULT = 0.05
% SldH ....(*) Hight of slider, given in FRACTIONS OF fH.
%              DEFAULT = 0.05
%              (*) After the slider     space ..... if any = 1.2*SldH
%                  and   the over title space ..... if any = 1.4*FtSz,
%                  what remains must be bigger than
%                  aH.  In this space the plot axis
%                  is then centered.
% valu ....... Initial value for slider.
%              DEFAULT = 3
% maxi ....... Maximum value for slider.
%              DEFAULT = 6
% mini ....... Minimum value for slider.
%              DEFAULT = 1
% step ....... Array with stepsizes for slider.
%              DEFAULT = [0.2 0.4]
% cbck ....... String with callback for slider.
%              DEFAULT = 'fprintf(''\n hello \n'')'
%
% NOTE: set hold to "on" before using plot, else all axis settings will be
%       obliterated by plot.
%
% NOTE: left and right margins biased on a 6 to 4 ratio.
%
%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ---------------------------- Copyright Notice ---------------------------
%
% Copyright 2000-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales 09-10-2000
% Update     by Rodolfo R. Rosales 11-29-2000
% Version 01 by Rodolfo R. Rosales 09-15-2000
% Update     by Rodolfo R. Rosales 11-29-2000
% Version 02 by Rodolfo R. Rosales 09-16-2000
% Update     by Rodolfo R. Rosales 11-29-2000
% Version 03 by Rodolfo R. Rosales 09-16-2000
% Update     by Rodolfo R. Rosales 11-29-2000
% Update     by Rodolfo R. Rosales 03-31-2002
% Update     by Rodolfo R. Rosales 03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software and
% its documentation, if any, for non-profit academic and research purposes,
% provided that the above copyright notice, this paragraph, and the
% following three paragraphs appear in all copies of this software. Use of
% this software constitutes acceptance of these terms and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR DIRECT,
% INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES ARISING OUT OF
% THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN IF MIT, OR THE
% AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO OBLIGATION
% TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS, OR MODIFICATIONS.
%
% -------------------------------------------------------------------------

if nargin == 0; Input.rand = 0; end
%
if ~isfield(Input, 'Name'); Input.Name = 'PSFGS_MakeFig_v02'; end
       Name = Input.Name;
if ~isfield(Input, 'Slid'); Input.Slid = 0; end
       Slid = Input.Slid;
if ~isfield(Input, 'FtSz'); Input.FtSz = 0.05; end
       FtSz = Input.FtSz;
if ~isfield(Input, 'SldH'); Input.SldH = 0.05; end
       SldH = Input.SldH;
if ~isfield(Input, 'OvTi'); Input.OvTi = [];   end
       OvTi = Input.OvTi;
if ~isfield(Input, 'Vsbl'); Input.Vsbl = 'on'; end
       Vsbl = Input.Vsbl;
%
if ~isfield(Input, 'dX'); Input.dX = 0.04; end
         dX = Input.dX;
if ~isfield(Input, 'dY'); Input.dY = 0.06; end
         dY = Input.dY;
if ~isfield(Input, 'fW'); Input.fW = 0.70; end
         fW = Input.fW;
if ~isfield(Input, 'fH'); Input.fH = 0.50; end
         fH = Input.fH;
if ~isfield(Input, 'aW'); Input.aW = 0.75; end
         aW = Input.aW;
if ~isfield(Input, 'aH'); Input.aH = 0.75; end
         aH = Input.aH;
%
if ~isfield(Input, 'valu'); Input.valu = 3; end
       valu = Input.valu;
if ~isfield(Input, 'maxi'); Input.maxi = 6; end
       maxi = Input.maxi;
if ~isfield(Input, 'mini'); Input.mini = 1; end
       mini = Input.mini;
if ~isfield(Input, 'step'); Input.step = [0.2 0.4]; end
       step = Input.step;
if ~isfield(Input, 'cbck'); Input.cbck = 'fprintf(''\n hello \n'')'; end
       cbck = Input.cbck;
%
% --- Get screen data and calculate:
%     SW = Screen Width
%     SH = Screen Height
%     Sml = Screen minimum length.
%
SSz = get(0, 'ScreenSize');  SW = SSz(3);  SH = SSz(4);  Sml = min(SW, SH);
% --- Calculate now figure position.
POF = [SW - (fW + dX)*Sml, SH - (fH + dY)*Sml, fW*Sml, fH*Sml];
% --- Setup figure.
Output.f = figure('Visible', 'off');
   PSZ = get(Output.f, 'PaperSize');
   if 0.80*PSZ(2)*fW >= 0.90*PSZ(1)*fH
      MAR = (PSZ(2)/PSZ(1) - 0.90*fH/fW)/2;
      POP = PSZ(1)*[0.05, MAR, 0.90, 0.90*fH/fW];
   else
      MAR = (PSZ(1)/PSZ(2) - 0.80*fW/fH)/2;
      POP = PSZ(2)*[MAR, 0.10, 0.80*fW/fH, 0.80];
   end
set(Output.f, 'Name',              [' ', Name, ' '], ...
              'NumberTitle',       'off', ...
              'Position',          POF, ...
              'PaperPosition',     POP, ...
              'PaperPositionMode', 'manual')
whitebg(Output.f, 'w')
%
% --- Setup axes.
%     OS = space reserved for the over-title.
%     SS = space reserved for the slider.
%     Left and right margins are biased by a 6 to 4 ratio.
%     Top and bottom margins, after the spaces OS and SS, are equal.
%
OS = 0;  if ~isempty(OvTi);  OS = 1.4*FtSz;  end
SS = 0;  if Slid == 1;       SS = 1.2*SldH;  end
POA = [0.6*(1-aW), SS+0.5*(1-aH-OS-SS), aW, aH];
set(gca, 'FontUnits',  'points', ...
         'FontWeight', 'demi', ...
         'FontSize',    16, ...
         'LineWidth',   2, ...
         'Position',    POA, ...
         'Box',         'on')
Output.a = gca;
%
% --- Setup overtitle.
%     Conversion from fractions of fH to axis normalized units:
%        divide by aH.
%     Also: text is centered on the height of the second coordinate. 
if ~isempty(OvTi)
   Output.o = text(0.50, 1 + 0.5*(1-aH-SS-OS+1.2*FtSz)/aH, ...
          ['{\bf ', OvTi, '}'], ...
         'FontUnits',           'Normalized', ...
         'Units',               'Normalized', ...
         'HorizontalAlignment', 'center', ...
         'FontSize',             FtSz/aH);

end
%
% --- Setup slider.
%
if Slid == 1
   POS = [POA(1), 0.1*SldH, aW, SldH];
   Output.s = uicontrol(...
                 'Style',           'slider', ...
                 'Value',            valu, ...
                 'Min',              mini, ...
                 'Max',              maxi, ...
                 'SliderStep',       step, ...
                 'Units',           'normalized', ...
                 'Position',         POS, ...
                 'CallBack',         cbck);
end
%
set(Output.f, 'Visible', Vsbl)
if nargout == 0; clear Output;   end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
