demoWBRch_v03_HowWork
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demoWBRch_v03_HowWork
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% This describes how the demoWBRch_v03 works:
%
% a) USER calls script with either 1 argument (EXAMPLE = number of the example
%    to be executed), or no argument (in which case script sets EXAMPLE = 1).
%
% b) All the other calls to the script  (by the various buttons or the slider)
%    involve two arguments, as follows:
%                                         demoWBRch_v03(EXAMPLE, N)
%
%    where now EXAMPLE is an array of handles --- see e below, and N indicates
%    who did the call. The various actions corresponding to the various values
%    of N are explained below, in (f).
%
% c) The script uses the following objects when in operation:
%                                                                            |
%    OBJECT                    TASK                          HANDLE NAME  N  |
%                                                                            |
%    Slider Window ........... display time evolution ...... FigSL           |
%    --- Slider .............. slide plots through time .... FigSLslidr   0  |
%    --- Movie/Stop button ... start/stop movie ............ FigSLmovie  1-2 |
%    --- Example button ...... change to next example ...... FigSLexmpl   3  |
%    --- Close button ........ ends script ................. FigSLclose   4  |
%                                                                            |
%    3D Window ............... 3D plot of solution ......... Fig3D           |
%    --- Example button ...... change to next example ...... Fig3Dexmpl   5  |
%    --- Close button ........ ends script ................. Fig3Dclose   6  |
%                                                                            |
%    Help Window ............. figure ...................... FigHW           |
%    --- List box ............ example list ................ FigHWexmpl      |
%    --- Close button ........ ends script ................. FigHWclose   7  |
%    --- Popup menu .......... select example .............. FigHWpopup   8  |
%                                                                            |
% The column N indicates the N used by callbacks from the indicated object.
% Note that the Movie/Stop has two values of N: Movie = 1; Stop = 2.
%
% d) The objects above are made when the user calls the script.   In succesive
%    callbacks by the buttons or by the slider, the existence of these various
%    objects is checked, and any missing is re-made  (except when the callback
%    is from one of the close buttons).
%
% e) The information needed to run the script is stored --- as a structure, in
%    the UserData for FigSLexmpl, Fig3Dexmpl, and FigHWexmpl.  When a callback
%    is done, it has the form
%                             demoWBRch_v03(EXAMPLE, N)
%    with                     EXAMPLE = [FigSLexmpl, Fig3Dexmpl, FigHWexmpl].
%
%    Thus, all the information can be recovered.
%
%    The three UserData are all equal.  Each is a structure with fields having
%    the names of the handles above (and containing the values of the handles)
%    and the following additional fields:
%
%    F, ts, tmax, umax, umin, xs, us, Nice_view, TITL, Nexa, Lexa, EXAMPLE.
%
%    These fields are explained with the subscript demoWBRch_v03_Example.
%    In addition the field
%                          UserData.CloseComnd
%
%    carries the (optional) user provided string to be executed when the
%    script is terminated by a close button [given by the input EXAMPLE{2}].
%    The default is ''.
%
% f) Actions corresponding to each value of N:
%
% --- N=0 corresponds to a CALL by the SLIDER.
%     Updates the 2D plot, using the sub script demoWBRch_v03_Slider.
%
% --- N=1 corresponds to a CALL by the MOVIE button.
%
%     For this button UserData = Play = 0
%
%     First:  The button is turned into the Stop button.
%             When the button is set to Stop,  Play = 1.
%             When the button is set to Movie, Play = 0.
%
%     Second: The slides are played as long as Play = 1. Each time the slider
%             value is upgraded by one, and the subscript demoWBRch_v03_Slider
%             is then used to upgrade the plot.
%
%     All this is carried out by demoWBRch_v03_movie.
%
% --- N=2 corresponds to a CALL by the STOP button. Then the button is turned
%     back to the Movie button (this changes Play to 0, and stops movie).
%
% --- N=3 corresponds to a CALL by the EXAMPLE button in the slider window,
%     to change example. Then the following actions are taken:
%
%     First:  upgrade example to next one.
%     Second: re-make any figure that has been deleted.
%     Third:  update the UserData for the two example buttons, and the list
%             box.
%     Fourth: update any other appropriate button/slider/popup info.
%
%     All this is carried out by demoWBRch_v03_ExFigSL.
%
% --- N=4, 6, 7 corresponds to a CALL by a CLOSE button: all open figures are
%     deleted.
%
% --- N=5 corresponds to a CALL by the EXAMPLE button in the 3D window. The
%     same actions as for N=3 are performed.
%
%     All this is carried out by demoWBRch_v03_ExFig3D.
%
% --- N=8 corresponds to a call by the popup menu. The example value from it
%     is read, and then actions similar to those for N=3 and N=5 are taken.
%
%     All this is carried out by demoWBRch_v03_popup.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
more on
demoWBRch_v03_HowWork
more off
%
%% EOF
