function [FigHW, FigHWexmpl, FigHWclose, FigHWpopup] = ...
         demoWBRch_v03_FigHW(Lexa, Vsbl)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [FigHW, FigHWexmpl, FigHWclose, FigHWpopup] = ...
%          demoWBRch_v03_FigHW(Lexa, Vsbl)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% This sub script makes the help window with the text in the string Lexa,  and
% returns the handles corresponding to the help window,  the list box with the
% example list, the close button, and the popup menu.
%
% The following are NOT set by the script:
% --- UserData for the list box.
% --- CallBack for the close button.
% --- CallBack for the popup menu.
% --- String   for the popup menu.
%
% Vsbl ....... can be either 'on', or 'off'. OPTIONAL; DEFAULT = 'on'.
%              Determines if figure is visible, or not.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2002 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Inpt.Name = 'Examples of solutions by characteristics.';
Inpt.Slid = 0;
Inpt.Vsbl = 'off';
Inpt.dX = 0.95;
Inpt.dY = 0.05;
Inpt.fW = 0.50;
Inpt.fH = 0.70;
Inpt.aW = 0.90;
Inpt.aH = 0.90;
%
Otpt  = demoWBRch_v03_MakeFig(Inpt);
FigHW = Otpt.f;% --- Help Window figure handle.
%
axis off
%
% ---List Box. ===============================================================
%
FigHWexmpl = uicontrol( ...
             'Style',           'ListBox', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.023, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'w', ...
             'Units',           'Normalized', ...
             'Position',         [0.02 0.00 0.98 0.92], ...
             'String',           Lexa);
%
% --- Close button. ==========================================================
%
FigHWclose = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'y', ...
             'Units',           'Normalized', ...
             'Position',         [0.02 0.93 0.20 0.06], ...
             'String',          'Close');
%
% --- Popup window. =========================================================
%
FigHWpopup = uicontrol( ...
             'Style',           'Popup', ...
             'FontWeight',      'bold', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'String',          'Example #1. |Example #2. ', ...
             'Value',            1, ...
             'Units',           'Normalized', ...
             'Position',         [0.30 0.93 0.70 0.06],...
             'BackGroundColor', 'y', ...
             'ForeGroundColor', 'k');
%
% --- Finish. ===============================================================
%
if nargin == 1;
   set(FigHW, 'Visible', 'on')
else
   set(FigHW, 'Visible', Vsbl)
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
