function Output = demoWBRch_v03_Example(EXAMPLE)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Output = demoWBRch_v03_Example(EXAMPLE)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% This sub-script produces the variables needed for a given example number as
% input. Output is a structure with the fields:
%
%      F, ts, tmax, umax, umin, xs, us, Nice_view, TITL, Nexa, Lexa, EXAMPLE.
%
% These fields contain the variables with the same names.  The variables here
% are as follows (some are only used internally):
%
% Ne:    Number of points in space grid. .......... PARAMETER: can be changed.
% Nt:    Number of points in time grid. ........... PARAMETER: can be changed.
%
% eta:   (1 x Ne) array with the characteristic "labels" in x=c*t+eta.
%        Equally spaced in [0 2*pi], with eta(1) = 0 and eta(Ne) = 2*pi.
% deta:  Equal spacing of the labels in eta.
% F:     (1 x Ne) array with the solution u --- u = F(eta).
% G:     (1 x Ne) array with the characteristic speeds, G = c(F(eta))
% ts:    (Nt x 1) array with the (equally spaced) time mesh.
% dt:    Equal spacing in the time mesh in ts.
% tmax:  Last time computed; t(1) = 0 and t(Nt) = tmax.
% umax:  Maximum value of the solution.
% umin:  Minimum value of the solution.
% xs:    (Nt x Ne) array with characteristics: xs(i,j)=G(j)*ts(i)+eta(j)
% us:    (Nt x Ne) array with solution: u(i,j) = F(j).
%
% Nice_view: String with a nice view setting for 3D plot.
% TITL:      String with title for plots.
%
% Nexa:  Number of available examples.
% Lexa:  String array with the list of examples (used in the HelpWindow).
%
% NOTE THAT THIS SCRIPT IS SET UP SO THAT ADDING MORE EXAMPLES IS TRIVIAL.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright 1999-2002 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FLAG = 0;% --- Turned to one if EXAMPLE has an appropriate value.
Nexa = 0;
Lexa = [ ...
         '                                                          '; ...
         ' SOLUTION BY CHARACTERISTICS of:                          '; ...
         '                                                          '; ...
         '    u_t + c(u)*u_x = 0,   with   u(x,0) = u_0.            '; ...
         '                                                          '; ...
         ' --- Popup    menu    selects example.                    '; ...
         ' --- Movie    button  starts a movie of evolution.        '; ...
         ' --- Stop     button  stops the movie.                    '; ...
         ' --- Example  buttons advance to next example.            '; ...
         ' --- Close    buttons terminate the demo.                 '; ...
         ' --- ZOOM     is ON for 2D plots.                         '; ...
         ' --- Rotate3D is ON for 3D plot,                          '; ...
         '                                                          '; ...
         ' These are the AVAILABLE EXAMPLES:                        '; ...
         '                                                          '];
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=u           and  u_0 = sin(x).                   '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 101;   Nt = 51;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = u  and  u_0 = sin(x).';
   F = sin(eta);   G = F;   tmax = 3;   umax = 1;   umin = -1;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=u           and  u_0 = exp(-(x-pi)^2).           '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 101;   Nt = 51;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = u  and  u_0 = exp(-(x-pi)^2).';
   F = exp(-(eta-pi).^2);   G = F;   tmax = 3;   umax = 1;   umin = 0;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=(1-2*u)     and  u_0 = 0.5*(1-sin(x)).           '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 101;   Nt = 51;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = 1 - 2u  and  u_0 = 0.5 (1-sin(x)).';
   F = 0.5*(1-sin(eta));   G = 1-2*F;   tmax = 3;   umax = 1;   umin = 0;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=(1-2*u)     and  u_0 = 0.5*(1-sin(x)) +          '; ...
         '                               0.6*exp(-3*(x-2)^2).       '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 101;   Nt = 53;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = 1 - 2u  and  u_0 = 0.5 (1-sin(x)) + 0.6exp (-3(x-2)^2).';
   F = 0.5*(1 - sin(eta)) + 0.6*exp( - 3*(eta - 2).^2);   G = 1 - 2*F;
   tmax = 4.5;   umax = 1;   umin = 0;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=(1-2*u)     and  u_0 = Zig-Zag.                  '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 101;   Nt = 46;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = 1 - 2u  and  u_0 = Zig-Zag.';
   F = min(abs(eta - pi/2), abs(eta - 5*pi/2))/pi;   G = 1 - 2*F;
   tmax = 1.5*pi;   umax = 1;   umin = 0;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=u           and  u_0 = "wavy".                   '; ...
         '                                                          ']; 
if EXAMPLE == Nexa
   Ne = 101;   Nt = 51;   deta=2*pi/(Ne-1);   eta=0:deta:2*pi;
   TITL = 'c = u  and  u_0 = "wavy".';
   F = sin(eta) + 0.2*sin(2*eta) + 0.4*sin(3*eta);   G = F;
   tmax = 4.6;   umax = 1.2;   umin = - 1.2;
   Nice_view = 'view(200,20)';
   FLAG = 1;
end
%
% ============================================================================
%
Nexa = Nexa + 1;
Ntxt = num2str(Nexa, '%02.0f');
Lexa = [Lexa; ' (', Ntxt, ')  ', ...
                'c=sqrt(u)     and  u_0 = 0.2 + 0.7*exp(-x^2).      '; ...
         '                                                          '];
if EXAMPLE == Nexa
   Ne = 151;   Nt = 51;   deta=4*pi/(Ne-1);   eta=-2*pi:deta:2*pi;
   TITL = 'c = u^{1/2}  and  u_0 = 0.2 + 0.7 exp(-x^2).';
   F = 0.2+0.7*exp(-eta.^2);  G = sqrt(F);  tmax = 6;  umax = 1;  umin = 0;
   Nice_view = 'view(-19,38)';
   FLAG = 1;
end
%
% ============================================================================
%
if FLAG == 0;
   Output = []; 
else
   dt  = tmax/(Nt-1);
   ts  = (0:dt:tmax)';
   UNO = ones(Nt, 1);
   xs  = ts*G + UNO*eta;
   us  = UNO*F;
   %
   Output.F         = F;
   Output.ts        = ts;
   Output.tmax      = tmax;
   Output.umax      = umax;
   Output.umin      = umin;
   Output.xs        = xs;
   Output.us        = us;
   Output.Nice_view = Nice_view;
   Output.TITL      = TITL;
   Output.Nexa      = Nexa;
   Output.Lexa      = Lexa;
   Output.EXAMPLE   = EXAMPLE;
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
