function demoWBRch_v03_ExFig3D(Handle)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function demoWBRch_v03_ExFig3D(Handle)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% Executes the 3D figure Example button callback.
% Handle is the handle for the button itself.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FLAG = 1; % --- Will turn to zero if any figure must be re-drawn.
UD = get(Handle, 'UserData');
%
% --- Update EXAMPLE number, and example data.
%
UD.EXAMPLE = (UD.EXAMPLE < UD.Nexa)*UD.EXAMPLE + 1;
Output     = demoWBRch_v03_Example(UD.EXAMPLE);
UD.F         = Output.F;
UD.ts        = Output.ts;
UD.tmax      = Output.tmax;
UD.umax      = Output.umax;
UD.umin      = Output.umin;
UD.xs        = Output.xs;
UD.us        = Output.us;
UD.Nice_view = Output.Nice_view;
UD.TITL      = Output.TITL;
%
% --- Set up exist values for windows  (must do
%     so BEFORE any window redrawn, because the
%     new handle may be equal to that of a gone
%     window).
%
NotHandleFigHW = ~ishandle(UD.FigHW);
NotHandleFigSL = ~ishandle(UD.FigSL);
%
% --- Check if Help Window still exist;
%     else, re-draw it, and update UD (UserData).
%
if NotHandleFigHW
   [FigHW, FigHWexmpl, FigHWclose, FigHWpopup] = ...
         demoWBRch_v03_FigHW(UD.Lexa, 'off');
   UD.FigHW      = FigHW;
   UD.FigHWexmpl = FigHWexmpl;
   UD.FigHWclose = FigHWclose;
   UD.FigHWpopup = FigHWpopup;
   %
   % --- SetUp string for the popupmenu.
   %
   Nexa = Output.Nexa;
   STRG = 'Example # 01. ';
   for n=2:Nexa
      STRG = [STRG, '|Example #', num2str(n, '%02.0f'), '. '];
   end
   set(FigHWpopup, 'String', STRG)
   FLAG = 0;
end
%
% --- Check if Slider window still exists;
%     else, redraw it, and update UD (UserData).
%
if NotHandleFigSL
   [FigSL, FigSLslidr, FigSLmovie, FigSLexmpl, FigSLclose] = ...
         demoWBRch_v03_FigSL(Output, 'off');
   UD.FigSL      = FigSL;
   UD.FigSLslidr = FigSLslidr;
   UD.FigSLmovie = FigSLmovie;
   UD.FigSLexmpl = FigSLexmpl;
   UD.FigSLclose = FigSLclose;
   FLAG = 0;
end
%
% --- Update UserData for buttons.
%
set(UD.Fig3Dexmpl, 'UserData', UD)
set(UD.FigSLexmpl, 'UserData', UD)
set(UD.FigHWexmpl, 'UserData', UD)
%
% --- Update stepping information for slider.
%
MXval = length(UD.ts);
set(UD.FigSLslidr,        ...
    'Value',      1,      ...
    'Max',        MXval,  ...
    'SliderStep', [1/(MXval-1), 0.2])
%
% --- Change labels in example buttons, and value for popup menu.
%
StrEx = ['Example #', num2str(UD.EXAMPLE, '%02.0f')];
set(UD.Fig3Dexmpl, 'String', StrEx)
set(UD.FigSLexmpl, 'String', StrEx)
set(UD.FigHWpopup, 'Value', UD.EXAMPLE)
%
% --- Update callbacks for buttons, slider and popup menu.
%
Handles = [UD.FigSLexmpl, UD.Fig3Dexmpl, UD.FigHWexmpl];
HdlsTxt = ['[', num2str(Handles, '%37.30e'), ']'];
%
set(UD.FigSLslidr, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 0)'])
set(UD.FigSLexmpl, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 3)'])
set(UD.FigSLclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 4)'])
set(UD.Fig3Dexmpl, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 5)'])
set(UD.Fig3Dclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 6)'])
set(UD.FigHWclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 7)'])
if strcmp('Movie', get(UD.FigSLmovie, 'String'))
   set(UD.FigSLmovie, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 1)'])
else
   set(UD.FigSLmovie, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 2)'])
end
set(UD.FigHWpopup, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 8)'])
%
% --- Update plots in FigSL, Fig3D, and
%     make hidden figures (if any) visible.
%
demoWBRch_v03_Slider(UD.FigSLexmpl)
set(UD.FigHW, 'Visible', 'on')
set(UD.FigSL, 'Visible', 'on')
demoWBRch_v03_Fig3D(Output, UD.Fig3D)
if FLAG == 0; figure(UD.Fig3D); end
drawnow
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
