% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demoWBRch
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% This demo shows various examples of the time evolution given by the equation
%
%                        u_t + c(u)*u_x = 0.
% 
% In all cases the evolution from initial conditions given for x in [0,  2*pi]
% are shown. The solution is calculated using CHARACTERISTICS
%
% See also evolveWBRch, which gives more flexibility.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2002 Massachusetts Institute of Technology
% This  version by Rodolfo R. Rosales  02-25-1999
% Update        by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ****************************  Abreviations used in the graphics: ***********
HNB = 'HelveticaNarrowBold';
FS  = 'FontSize';
FN  = 'FontName';
LW  = 'LineWidth';
%
% The script works as follows: ***********************************************
% eta:   (1 x Ne) array with the characteristic "labels" in x=c*t+eta.
%        Equally spaced in [0 2*pi], with eta(1) = 0 and eta(Ne) = 2*pi.
% deta:  Equal spacing of the labels in eta.
% F:     (1 x Ne) array with the solution u --- u = F(eta).
% G:     (1 x Ne) array with the characteristic speeds, G = c(F(eta))
% ts:    (Nt x 1) array with the (equally spaced) time mesh.
% dt:    Equal spacing in the time mesh in ts.
% tmax:  Last time computed; t(1) = 0 and t(Nt) = tmax.
% umax:  Maximum value of the solution.
% umin:  Minimum value of the solution.
% xs:    (Nt x Ne) array with characteristics: xs(i,j)=G(j)*ts(i)+eta(j)
% us:    (Nt x Ne) array with solution: u(i,j) = F(j).
% Ne:    Number of points in space grid. .............. PARAMETER: can change.
% Nt:    Number of points in time grid. ............... PARAMETER: can change.
% Nskip: Skip used for frame by frame slide show. ..... PARAMETER: can change.
%
% NOTE THAT SCHEME IS SET UP SO ADDING MORE OPTIONS IS EASY.
%
FLAG = 1;
while FLAG >= 1 %%%%%%%%%%%%%%  BEGINS BIG "WHILE" TO END OF CODE. %%%%%%%%%%%
fprintf('\n SOLUTION BY CHARACTERISTICS of: \n')
fprintf('\n               u_t + c(u)*u_x = 0, u(x,0) = u_0. \n')
fprintf('\n You have the following OPTIONS: ')
fprintf('\n (1) c=u       and u_0 = sin(x).')
fprintf('\n (2) c=u       and u_0 = exp(-(x-pi)^2).')
fprintf('\n (3) c=(1-2*u) and u_0 = 0.5*(1-sin(x)).')
fprintf('\n (4) c=(1-2*u) and u_0 = 0.5*(1-sin(x))+0.6*exp(-3*(x-2)^2).')
fprintf('\n (5) c=(1-2*u) and u_0 = Zig-Zag.')
fprintf('\n (6) c=u       and u_0 = "wavy". \n')
%
OPTION = input(' Enter OPTION = ');
%
%---------------- BEGINS IF TO EVALUATE Initial Conditions given OPTION @@@@@@
if OPTION == 1
   Ne = 101; Nt = 51; Nskip = 5;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = u  and  u_0 = sin(x).';
   F  = sin(eta);
   G  = F;
   tmax = 3;
   umax = 1;
   umin = -1;
   Nice_view = 'view(200,20)';
elseif OPTION == 2
   Ne = 101; Nt = 51; Nskip = 5;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = u  and  u_0 = exp(-(x-pi)^2).';
   F  = exp( - (eta - pi).^2);
   G  = F;
   tmax = 3;
   umax = 1;
   umin = 0;
   Nice_view = 'view(200,20)';
elseif OPTION == 3
   Ne = 101; Nt = 51; Nskip = 5;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = 1-2*u  and  u_0 = 0.5*(1-sin(x)).';
   F  = 0.5*(1 - sin(eta));
   G  = 1 - 2*F;
   tmax = 3;
   umax = 1;
   umin = 0;
   Nice_view = 'view(200,20)';
elseif OPTION == 4
   Ne = 101; Nt = 53; Nskip = 4;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = 1-2*u  and  u_0 = 0.5*(1-sin(x))+0.6*exp(-3*(x-2)^2).';
   F  = 0.5*(1 - sin(eta)) + 0.6*exp( - 3*(eta - 2).^2);
   G  = 1 - 2*F;
   tmax = 4.5;
   umax = 1;
   umin = 0;
   Nice_view = 'view(200,20)';
elseif OPTION == 5
   Ne = 101; Nt = 46; Nskip = 5;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = 1-2*u  and  u_0 = Zig-Zag.';
   F  = min(abs(eta - pi/2), abs(eta - 5*pi/2))/pi;
   G  = 1 - 2*F;
   tmax = 1.5*pi;
   umax = 1;
   umin = 0;
   Nice_view = 'view(200,20)';
elseif OPTION == 6
   Ne = 101; Nt = 51; Nskip = 5;       %%%%%%% PARAMETERS, can change at will.
   deta = 2*pi/(Ne-1); eta=0:deta:2*pi;
   TITLE = 'c = u  and  u_0 = "wavy".';
   F  = sin(eta) + 0.2*sin(2*eta) + 0.4*sin(3*eta);
   G  = F;
   tmax = 4.6;
   umax = 1.2;
   umin = - 1.2;
   Nice_view = 'view(200,20)';
end  % @@@@@@@@@@@@@@@@@@@@@@@@@@@@@@@ END OF OPTIOMS IF @@@@@@@@@@@@@@@@@@@@@
%
%
dt = tmax/(Nt-1);
ts = (0:dt:tmax)';
UNO = ones(Nt, 1);
xs  = ts*G + UNO*eta;
us  = UNO*F;
% ---------------------------------------------------------------- SLIDE Show.
fprintf('\n PRESS ANY KEY (& CONTINUE) to see a Slide Show. \n')
pause
figure
whitebg('k')
for n=1:Nskip:Nt
   TIME = num2str(ts(n));
   plot(xs(n, :), F, '-c', LW, 3)
   axis([0 2*pi umin umax])
   grid on
   title(TITLE, FN, HNB, FS, 18)
   xlabel(['Space x --- time is now  t = ', TIME], FN, HNB, FS, 16)
   ylabel('Solution  u', FN, HNB, FS, 16)
   if (n+Nskip) <= Nt
      pause
   end
end
fprintf('\n END of SLIDESHOW. \n')
fprintf('\n PRESS ANY KEY to see THREE D graph of solution. \n')
pause
% ---------------------------------------------------- TWO-D plot of solution.
figure
whitebg('k')
axis([0 2*pi 0 tmax umin umax])
hold on
eval(Nice_view);
title(TITLE, FN, HNB, FS, 18)
xlabel('Space  x', FN, HNB, FS, 16)
ylabel('Time  t', FN, HNB, FS, 16)
zlabel('Solution  u', FN, HNB, FS, 16)
surf(xs, ts, us)
colormap(hsv)
shading interp
grid on
hold off
% --------------------------------------------- Now choice to end or continue.
%
FLAG = input(' To STOP enter 0 now, ELSE enter 1. CHOICE = ');
%
end %%%%%%%%%%%%%%%%%%%%%%%%%%  END OF BIG "WHILE" TO REPEAT DEMO. %%%%%%%%%%%
%
fprintf('\n Bye.  Use "close all" to close all the figures. \n')
fprintf('\n')
%
% ------------------------------------------------------------------ CLEAN UP.
% ---- clear auxiliary variables
clear  LW FN FS FLAG HNB Nice_view OPTION TIME TITLE UNO n
% ---- clear working variables
clear  eta deta F G ts dt tmax umax umin xs us Ne Nt Nskip
%
%% END OF FILE
