% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% readmeHFT 
%            Contents of directory Heat_FT
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% This directory has three demos (first three scripts --- see their helps):
%
% fourierSC ...... Illustrates the convergence of the Fourier Series of a 2*pi
%                  periodic function F(x) to the function as more & more terms
%                  are added. Several functions F(x) are provided in a menu of
%                  examples, with an option for the user to add his own.
% heatSln ........ Displays the solution of the heat equation  T_t = T_xx as a
%                  function of time, with initial conditions given by the same
%                  functions F(x) used by fourierSC.    Illustrates the use of
%                  spectral techniques for the numerical solution of PDE's.
% gibbsFSE ....... Illustrates the GIBBS phenomenon for convergence of Fourier
%                  series near discontinuities.
% FSFun .......... User provided function for input  into fourierSC   or  into
%                  heatSln, selected when OPTION=0 is picked.   Must be in the
%                  directory from which the user is running MatLab.   Given an
%                  array containing the x variable,  it must produce the array
%                  y with the values of the function.
%                  Example of a FSFun.m file:
%
%                          function y = FSFun(x)
%                          %
%                          y = (x.^2).*(x-2*pi).^2;
%
%                  Note the use of vector operands here  (.* and .^)  required
%                  because both x and y are arrays.  The array x is defined in
%                  both fourierSC and heatSln by: x = 0:dx:2*pi-dx --- some dx
%                  that depends on the (user prescribed) resolution.
%         >>>>>>>> Check help FSFun for  important details about how to define
%                  the function when dealing with discontinuities!
%         >>>>>>>> NOTE: help FSFun will NOT work if the current directory for
%                  MatLab has a user constructed  FSFun.m file already in it.
% FSoption ....... Script to construct the functions F(x) used by heatSln  and
%                  fourierSC ("fancy", with buttons).
% FSoptionP ...... Same as FSoption, but without buttons.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
help readmeHFT
%
% EOF
