% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FSoptionP
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
%            SAME AS FSoption, but simpler input setup (no buttons)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FN  = 'FontName';             % Stuff to get nice text.
HNB = 'HelveticaNarrowBold';  %
FS  = 'FontSize';             %
BGC = 'BackGroundColor';      % To get button colors.
%
%
%===========================================================================
%################ MAKE FIGURE WITH CHOICES. ################################
%
%
h_fig = figure;
whitebg('k')
axis off
title('Click mouse on function to make a choice:', FN, HNB, FS, 22)
dl = 0.025; dy = 0.07; YT = 0.95;
%
DOTS  = '------------------------------------------------';
TEXT  = 'USER-s CHOICE (Need function script: FSFun.m).'; % OPTION = 0
TEXTT = 'GAUSSIAN centered at pi (even & smooth).      '; % OPTION = 1
TEXT  = [TEXT; TEXTT];
TEXTT = 'Alternating GAUSSIAN centered at pi (odd).    '; % OPTION = 2
TEXT  = [TEXT; TEXTT];
TEXTT = 'Smooth HAT, centered at pi (even).            '; % OPTION = 3
TEXT  = [TEXT; TEXTT];
TEXTT = 'HAT, centered at pi (even, with corner).      '; % OPTION = 4
TEXT  = [TEXT; TEXTT];
TEXTT = 'Smooth SAWTOOTH (odd).                        '; % OPTION = 5
TEXT  = [TEXT; TEXTT];
TEXTT = 'SAWTOOTH (odd and discontinuous).             '; % OPTION = 6
TEXT  = [TEXT; TEXTT];
TEXTT = 'Smooth SQUARE WAVE (even).                    '; % OPTION = 7
TEXT  = [TEXT; TEXTT];
TEXTT = 'Smooth nonsymmetric SQUARE WAVE.              '; % OPTION = 8
TEXT  = [TEXT; TEXTT];
TEXTT = 'SQUARE WAVE (even and discontinuous).         '; % OPTION = 9
TEXT  = [TEXT; TEXTT];
TEXTT = 'Cusp (even, with square root cusp).           '; % OPTION = 10
TEXT  = [TEXT; TEXTT];
TEXTT = 'ROUND HAT (even, NOT smooth: corner at edge). '; % OPTION = 11
TEXT  = [TEXT; TEXTT];
TEXTT = 'UNSYMMETRIC WAVE, smooth.                     '; % OPTION = 12
TEXT  = [TEXT; TEXTT];
CLR(1)  = 'y';   CLR(2)  = 'c';   CLR(3)  = 'g';
CLR(4)  = 'y';   CLR(5)  = 'c';   CLR(6)  = 'g';
CLR(7)  = 'y';   CLR(8)  = 'c';   CLR(9)  = 'g';
CLR(10) = 'y';   CLR(11) = 'c';   CLR(12) = 'g';
CLR(13) = 'y';
%
yt = YT;
text(0, yt+dy-dl, [DOTS, DOTS]);
for nop=1:13
  yl = yt - dl;
  text(0, yt, TEXT(nop, :), 'units', 'normal', 'color', CLR(nop), FN, HNB, FS, 16);
  text(0, yl, [DOTS, DOTS]);
  yt = yt - dy;
end

[x_m, y_m] = ginput(1);
OPTION = floor((YT + dy -dl - y_m)/dy);
figure(h_fig); close
%
%
%===========================================================================
%##################### NOW CALCULATE THE FUNCTION. #########################
%
%
[jn NN] = size(x);      fct = zeros(1,NN);      MM = floor(NN/2 + 0.1);
smooth = exp(-(0.1*[0:MM-1, (MM-NN):(-1)]).^2);
if OPTION == 0      %==== User choice. ################################
   fprintf('\n Your choice is: USER CHOICE.\n')
   fct = FSFun(x);
elseif OPTION == 1  %==== Gaussian. ###################################
   fprintf('\n Your choice is: GAUSSIAN (even).\n')
   fct = exp(-4*(x+pi).^2) + exp(-4*(x-pi).^2) + exp(-4*(x-3*pi).^2);
elseif OPTION == 2  %==== Alternating Gaussian. #######################
   fprintf('\n Your choice is: ALTERNATING GAUSSIAN (odd).')
   fct = exp(-4*(x + 1.5*pi).^2) - exp(-4*(x + 0.5*pi).^2) + ...
         exp(-4*(x - 0.5*pi).^2) - exp(-4*(x - 1.5*pi).^2) + ...
         exp(-4*(x - 2.5*pi).^2) - exp(-4*(x - 3.5*pi).^2);
elseif OPTION == 3  %==== Smooth Hat. #################################
   fprintf('\n Your choice is: SMOOTH HAT (even).\n')
   fct = 1 - abs(x - pi)/pi;
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 4  %==== Hat #########################################
   fprintf('\n Your choice is: HAT (even).\n')
   fct = 1 - abs(x - pi)/pi;
elseif OPTION == 5  %==== Smooth Saw_tooth. ###########################
   fprintf('\n Your choice is: SMOOTH SAW_TOOTH (odd).\n')
   fct = x/pi + (sign(pi-x) - 1);
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 6  %==== Saw_tooth. ##################################
   fprintf('\n Your choice is: SAW_TOOTH (odd).\n')
   fct = x/pi + (sign(pi-x) - 1);
elseif OPTION == 7  %==== Smooth square wave. #########################
   fprintf('\n Your choice is: SMOOTH SQUARE WAVE (even).\n')
   fct = (sign(x - pi/2) + sign(1.5*pi - x))/2;
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 8  %==== Smooth nonsymetric square wave. #############
   fprintf('\n Your choice is: SMOOTH NON-SYMMETRIC SQUARE WAVE.\n')
   fct = (erf(2*(x + 1.5*pi)) + erf(4*(-0.5*pi - x)))/2 + ...
         (erf(2*(x - 0.5*pi)) + erf(4*( 1.5*pi - x)))/2 + ...
         (erf(2*(x - 2.5*pi)) + erf(4*( 3.5*pi - x)))/2;
elseif OPTION == 9  %==== Square wave. ################################
   fprintf('\n Your choice is: SQUARE WAVE (even).\n')
   fct = (sign(x - pi/2) + sign(1.5*pi - x))/2;
elseif OPTION == 10 %==== Cusp. #######################################
   fprintf('\n Your choice is: Cusp (even).\n')
   fct = sqrt(pi) - sqrt(abs(x-pi));
elseif OPTION == 11 %==== Round Hat ###################################
   fprintf('\n Your choice is: ROUND HAT (even, NOT smooth).\n')
   fct = 1 - (abs(x - pi)/pi).^1.5;
%
elseif OPTION == 12 %==== Unsymmetric wave ############################
   fprintf('\n Your choice is: UNSYMMETRIC WAVE.\n')
   fct = exp(1.5*sin(x))/exp(1.5);
end
%
% End Of File.
