% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%  FSoption
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
%                  FINAL ANSWER is in array fct
%
% Auxiliary script to compute a 2*pi periodic function of the array x   (which
% can be ROW array), in the interval 0 < x <= 2*pi.   Many options are offered
% via screen choices.   Used by both heatSln to provide initial values for the
% heat equation and by fourierSC, to study Fourier Series convergence.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FN  = 'FontName';             % Stuff to get nice text.
HNB = 'HelveticaNarrowBold';  %
FS  = 'FontSize';             %
BGC = 'BackGroundColor';      % To get button colors.
%
%
%===========================================================================
%################ MAKE FIGURE WITH BUTTONS FOR CHOICES. ####################
%
%
h_fig = figure;
whitebg('k')
axis off
title('Push a button and make a choice:', FN, HNB, FS, 22)
dyb = 0.055; dyt = 0.0675;
%
TEXT = 'USER-s CHOICE (Need function script: FSFun.m).'; % TEXT BY BUTTON
OPT  = 'OPTION = 0;';                                    % OPTION LABEL
CLR  = 'y';                                              % COLOR USED
yb = 0.85; yt = 0.92;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'GAUSSIAN centered at pi (even & smooth).';       % TEXT BY BUTTON
OPT  = 'OPTION = 1;';                                    % OPTION LABEL
CLR  = 'c';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Alternating GAUSSIAN (odd & smooth).';           % TEXT BY BUTTON
OPT  = 'OPTION = 2;';                                    % OPTION LABEL
CLR  = 'g';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Smooth HAT, centered at pi (even).';             % TEXT BY BUTTON
OPT  = 'OPTION = 3;';                                    % OPTION LABEL
CLR  = 'y';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'HAT, centered at pi (even, with a corner).';     % TEXT BY BUTTON
OPT  = 'OPTION = 4;';                                    % OPTION LABEL
CLR  = 'c';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Smooth SAWTOOTH (odd).';                         % TEXT BY BUTTON
OPT  = 'OPTION = 5;';                                    % OPTION LABEL
CLR  = 'g';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'SAWTOOTH (odd, with discontinuity).';            % TEXT BY BUTTON
OPT  = 'OPTION = 6;';                                    % OPTION LABEL
CLR  = 'y';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Smooth SQUARE WAVE (even).';                     % TEXT BY BUTTON
OPT  = 'OPTION = 7;';                                    % OPTION LABEL
CLR  = 'c';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Smooth non symmetric SQUARE WAVE.';              % TEXT BY BUTTON
OPT  = 'OPTION = 8;';                                    % OPTION LABEL
CLR  = 'g';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'SQUARE WAVE (even, with discontinuity).';        % TEXT BY BUTTON
OPT  = 'OPTION = 9;';                                    % OPTION LABEL
CLR  = 'y';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'Cusp (even, with a square root cusp).';          % TEXT BY BUTTON
OPT  = 'OPTION = 10;';                                   % OPTION LABEL
CLR  = 'c';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'ROUND HAT (even, NOT smooth: corner at edge).';  % TEXT BY BUTTON
OPT  = 'OPTION = 11;';                                   % OPTION LABEL
CLR  = 'g';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
TEXT = 'UNSYMMETRIC WAVE (smooth).';                     % TEXT BY BUTTON
OPT  = 'OPTION = 12;';                                   % OPTION LABEL
CLR  = 'y';                                              % COLOR USED
yb = yb - dyb; yt = yt - dyt;
h=uicontrol('style','push','units','normal','pos',[0.08 yb 0.04 0.04], ...
            'string', 'X', 'Callback', OPT, BGC, CLR);
text(0, yt, TEXT, 'units', 'normal', 'color', CLR, FN, HNB, FS, 16);
%
waitforbuttonpress;
pause(1)
figure(h_fig); close
%
%
%===========================================================================
%##################### NOW CALCULATE THE FUNCTION. #########################
%
%
[jn NN] = size(x);      fct = zeros(1,NN);      MM = floor(NN/2 + 0.1);
smooth = exp(-(0.1*[0:MM-1, (MM-NN):(-1)]).^2);
if OPTION == 0      %==== User choice. ################################
   fprintf('\n Your choice is: USER CHOICE.\n')
   fct = FSFun(x);
elseif OPTION == 1  %==== Gaussian. ###################################
   fprintf('\n Your choice is: GAUSSIAN (even).\n')
   fct = exp(-4*(x+pi).^2) + exp(-4*(x-pi).^2) + exp(-4*(x-3*pi).^2);
elseif OPTION == 2  %==== Alternating Gaussian. #######################
   fprintf('\n Your choice is: ALTERNATING GAUSSIAN (odd).')
   fct = exp(-4*(x + 1.5*pi).^2) - exp(-4*(x + 0.5*pi).^2) + ...
         exp(-4*(x - 0.5*pi).^2) - exp(-4*(x - 1.5*pi).^2) + ...
         exp(-4*(x - 2.5*pi).^2) - exp(-4*(x - 3.5*pi).^2);
elseif OPTION == 3  %==== Smooth Hat. #################################
   fprintf('\n Your choice is: SMOOTH HAT (even).\n')
   fct = 1 - abs(x - pi)/pi;
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 4  %==== Hat #########################################
   fprintf('\n Your choice is: HAT (even).\n')
   fct = 1 - abs(x - pi)/pi;
elseif OPTION == 5  %==== Smooth Saw_tooth. ###########################
   fprintf('\n Your choice is: SMOOTH SAW_TOOTH (odd).\n')
   fct = x/pi + (sign(pi-x) - 1);
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 6  %==== Saw_tooth. ##################################
   fprintf('\n Your choice is: SAW_TOOTH (odd).\n')
   fct = x/pi + (sign(pi-x) - 1);
elseif OPTION == 7  %==== Smooth square wave. #########################
   fprintf('\n Your choice is: SMOOTH SQUARE WAVE (even).\n')
   fct = (sign(x - pi/2) + sign(1.5*pi - x))/2;
   fct = real(ifft(fft(fct).*smooth));
elseif OPTION == 8  %==== Smooth nonsymetric square wave. #############
   fprintf('\n Your choice is: SMOOTH NON-SYMMETRIC SQUARE WAVE.\n')
   fct = (erf(2*(x + 1.5*pi)) + erf(4*(-0.5*pi - x)))/2 + ...
         (erf(2*(x - 0.5*pi)) + erf(4*( 1.5*pi - x)))/2 + ...
         (erf(2*(x - 2.5*pi)) + erf(4*( 3.5*pi - x)))/2;
elseif OPTION == 9  %==== Square wave. ################################
   fprintf('\n Your choice is: SQUARE WAVE (even).\n')
   fct = (sign(x - pi/2) + sign(1.5*pi - x))/2;
elseif OPTION == 10 %==== Cusp. #######################################
   fprintf('\n Your choice is: Cusp (even).\n')
   fct = sqrt(pi) - sqrt(abs(x-pi));
elseif OPTION == 11 %==== Round Hat ###################################
   fprintf('\n Your choice is: ROUND HAT (even, NOT smooth).\n')
   fct = 1 - (abs(x - pi)/pi).^1.5;
%
elseif OPTION == 12 %==== Unsymmetric wave ############################
   fprintf('\n Your choice is: UNSYMMETRIC WAVE.\n')
   fct = exp(1.5*sin(x))/exp(1.5);
end
%
% End Of File.
