% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demoENV
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Demo with some examples of envelopes of characteristics speeds.  Illustrates
% the functions envelope and ch_speed.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  04-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('\n Will plot characteristics and their envelope for the equation \n')
fprintf('\n      u_t + c(u)*u_x. \n')
fprintf('\n OPTIONS: \n')
fprintf('\n # 1: c(x, 0) = 1/(1 + x^2). \n')
fprintf(' # 2: c(x, 0) = -sin(x). \n')
fprintf(' # 3: c(x, 0) = sin(x) + 1.5*sin(2*x). \n')
fprintf(' # 4: c(x, 0) = exp(-x^2) + 0.25*exp(-(s-2.5)^2). \n')
flag = input('ENTER choice of OPTION # = ');
fprintf('\n')
%
if flag == 1
  sc = [-3:0.1:0, 0:0.25:7];
  se = -1:0.1:2.5;
  T  =  10;
  a  =  -1;
  b  =   6;
end
%
if flag == 2
  sc = -4:0.14:10;
  se = -3:0.10:8;
  T  =  10;
  a  =  -2;
  b  =   8;
end
%
if flag == 3
  sc = -10:0.10:23;
  se = -10:0.05:23;
  T  =    4;
  a  =    0;
  b  = 4*pi;
end
%
if flag == 4
  sc = -2:0.10:10;
  se = -1:0.05:10;
  T  = 20;
  a  =  0;
  b  =  8;
end
%
envelope(sc, se, T, a, b, flag)
%
clear   T   b   sc   a   flag   se    
%
% EOF
