function [C, D] = ch_speed(s, flag)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [C, D] = ch_speed(s, flag)
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Used by envelope. It should give the characteristic speed C = c(F(s))   (and
% its derivative D(s)=dC/ds for the problem
% 
%                    k_t + c(k) * k_x = 0,   k(x, 0) = F(x).
%
% It SHOULD BE WRITTEN SO THAT s CAN BE AN ARRAY!!   The default function does
% the following examples, corresponding to various values of flag:
%  
% flag = 1  C = (1 + s.^2).^(-1);     D = - 2*s.*(1 + s.^2).^(-2);
% flag = 2  C = - sin(s);             D = - cos(s)
% flag = 3  C = sin(s)+1.5*sin(2*s);  D = cos(s)+3*cos(2*s);
% flag = 4  C = exp(-s.^2) + 0.25*exp(-(s-2.5).^2);
%           D = -2.0*s.*exp(-s.^2) -0.5*(s-2.5).*exp(-(s-2.5).^2);
%
% If a function script ch_speed (as above)  exists in the current directory of
% MatLab, it will be used instead of the default ---  this allows examples the
% user can pick.     NOTE though: such a script will affect the demoENV, which
% will not work as planned (or not at all) since it assumes the default choice
% for ch_speed. One should use the script envelope directly (and not the demo)
% to do user picked examples.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  04-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

if flag == 1
  C = (1 + s.^2).^(-1); D = - 2 * s .* (1 + s.^2).^(-2);
end
%
if flag == 2
  C = - sin(s); D = - cos(s);
end
%
if flag == 3
  C = sin(s) + 1.5*sin(2*s); D = cos(s) + 3*cos(2*s);
end
%
if flag == 4
  C = exp(-s.^2) + 0.25*exp(-(s-2.5).^2);
  D = - 2.0*s.*exp(-s.^2) - 0.5*(s-2.5).*exp(-(s-2.5).^2);
end
% 
%% END OF FILE
