function EIKOdemo(Ex, SliderHandle)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% EIKOdemo
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Demo with some examples illustrating the evolution of wave fronts,  as given
% by the Eikonal equation  (Phi_x)^2 + (Phi_y)^2 = 1 --- motion at unit speed,
% normal to the wavefront.
%
% The rays and caustics are also shown.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-15-2001.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin == 2% --- Two inputs are used by the slider callback.
   EIKOdemo_plot(SliderHandle);   return;   end
% ____________________________________________________________________________
% --- If the user does not give a selection, this goes through the list %%%%%%
%     of available example files, allowing the user to pick an example. %%%%%%
%
if nargin == 0;   fprintf('\n These are the currently available examples:')
   ExistNN = 2;   nn = 0;
   while ExistNN == 2
      nn = nn+1;   Example = ['EIKOexample', num2str(nn,'%02.0f')];
      ExistNN = exist(Example);
      if ExistNN == 2;   eval([Example, '(0)']);   end
   end
   fprintf('\n Select 0 to stop now.\n')
   Ex = input(' Select an example and enter your selection number: Ex = ');
   if isempty(Ex);   EIKOdemo;   return;   end
end
% ____________________________________________________________________________
% --- Check that selected example exists. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
if Ex == 0; return; end
if exist(['EIKOexample', num2str(Ex,'%02.0f')]) ~= 2;  EIKOdemo;  return;  end
% ____________________________________________________________________________
% --- If an example choice is given, execute the example file. %%%%%%%%%%%%%%%
%
eval(['Output = EIKOexample', num2str(Ex,'%02.0f'), ';'])
exa = Output.exa;
Nsl = Output.Nsl;
txt = Output.txt;
% ____________________________________________________________________________
% --- Setup slider figure. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Inpt.Name = 'Eikonal wavefront evolution / Caustics.';   Inpt.dX = 0.05;
Inpt.Slid = 1;                                           Inpt.dY = 0.06;
Inpt.SldH = 0.05;                                        Inpt.fW = 0.85;
Inpt.valu = 1;   Inpt.mini = 1;   Inpt.maxi = Nsl+1;     Inpt.aW = 0.80;
Inpt.step = [1/Nsl, max(0.2, 2/Nsl)];                    Inpt.fH = 0.85;
Inpt.cbck = '--';                                        Inpt.aH = 0.80;
%
Outpt = MakeFig311_v00(Inpt);   whitebg(Outpt.f, 'k');   Output.a = gca;
set(Outpt.s, ...
   'CallBack', ['EIKOdemo(0, ', num2str(Outpt.s, '%37.30e') , ')'], ...
   'UserData', Output)
%
EIKOwelcomeScreenPlot(txt, exa)
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function EIKOwelcomeScreenPlot(txt, exa)  % Welcome text in plot windows.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Bo = 'Bold';                FS = 'FontSize';     No = 'Normalized';
Ce = 'Center';              FU = 'FontUnits';    Po = 'Position';
Co = 'Color';               FW = 'FontWeight';   Un = 'Units';
HA = 'HorizontalAlignment';
text(Un, No, Po, [0.50, 0.96], FU, No, FW, Bo, FS, 0.08, HA, Ce, ...
     'String', 'Eikonal equation')
text(Un, No, Po, [0.50, 0.83], FU, No, FW, Bo, FS, 0.08, HA, Ce, ...
     'String', ' (\Phi_x)^2 + (\Phi_y)^2 = 1')
text(Un, No, Po, [0.50, 0.70], FU, No, FW, Bo, FS, 0.08, HA, Ce, ...
     'String', 'wavefront evolution.')
text(Un, No, Po, [0.50, 0.56], FU, No, FW, Bo, FS, 0.07, HA, Ce, Co, 'c', ...
     'String', exa)
text(Un, No, Po, [0.50, 0.46], FU, No, FW, Bo, FS, 0.045, HA, Ce, Co, 'c', ...
     'String', txt)
text(Un, No, Po, [0.00, 0.33], FU, No, FW, Bo, FS, 0.05, ...
     'String', 'Initial wave front: yellow curve.')
text(Un, No, Po, [0.00, 0.26], FU, No, FW, Bo, FS, 0.05, ...
     'String', 'Current wave front: cyan curve.')
text(Un, No, Po, [0.00, 0.19], FU, No, FW, Bo, FS, 0.05, ...
     'String', 'Caustic: red curve.')
text(Un, No, Po, [0.00, 0.12], FU, No, FW, Bo, FS, 0.05, ...
     'String', 'Typical rays: green lines.')
text(Un, No, Po, [0.50, 0.00], FU, No, FW, Bo, FS, 0.07, HA, Ce, Co, 'y', ...
     'String', 'Use the slider to see the plots.')
axis off
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function EIKOdemo_plot(SliderHandle) % Called by slider to plot.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
Bo = 'Bold';        FW = 'FontWeight';            Po = 'Position';
Co = 'Color';       HA = 'HorizontalAlignment';   Ri = 'Right';
FS = 'FontSize';    LW = 'LineWidth';             St = 'String';
FU = 'FontUnits';   No = 'Normalized';            Un = 'Units';
%
Output = get(SliderHandle, 'UserData');
%
xmin = Output.xmin;   xray = Output.xray;   exa = Output.exa;   a = Output.a;
xmax = Output.xmax;   norx = Output.norx;   txt = Output.txt;   X = Output.X;
ymin = Output.ymin;   yray = Output.yray;   Nsl = Output.Nsl;   Y = Output.Y;
ymax = Output.ymax;   nory = Output.nory;   Nra = Output.Nra;   T = Output.T;
%
n = round(get(SliderHandle, 'Value'));
%
axes(a); cla reset
if n == 1;
   EIKOwelcomeScreenPlot(txt, exa)
elseif 1 < n
   TIME = num2str(T(n-1), '%06.4f');
   if Nra > 0
      x = [xray; xray + T(n-1)*norx]; y = [yray; yray + T(n-1)*nory];
      plot(x, y, '-g', LW, 2)
   end
   hold on;   grid on;   zoom on
   x = X(1, :);   y = Y(1, :);     plot(x, y, '-y', LW, 4)
   x = X(n-1, :); y = Y(n-1, :);   plot(x, y, '-c', LW, 4)
   plot(Output.xe, Output.ye, '-r', LW, 4)
   set(a, FW, Bo, FU, No, FS, 0.035, LW, 2, 'Box', 'on')
   title(['{\bf Wave front for t = ', TIME, '}'], FU, No, FS, 0.06, 'Co', 'y')
   text(Un, No, Po, [-0.10 1.050], FU, No, FS, 0.08, St, '{\bf y}')
   text(Un, No, Po, [1.00 -0.070], FU, No, FS, 0.08, St, '{\bf x}')
   text(Un, No, Po, [-0.09 -0.07], FU, No, FS, 0.04, Co, 'y', ...
        St, ['{\bf ', txt, '}'])
   axis([xmin xmax ymin ymax])
   text(Un, No, Po, [1.05 0.97], FU, No, FS, 0.055, 'Rotation', -90, St, ...
        '{\bf Use the mouse to zoom-in details.}')
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
