function Output = EIKO3Dexample04(N)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Output = EIKO3Dexample04(N)
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Provides the data needed to make a plot for the evolution of a wave-front by
% the Eikonal equation (Phi_x)^2 + (Phi_y)^2 + (Phi_z)^2 = 1 -- motion at unit
% speed, normal to the wavefront.
%
% When N = 0, it should print on the screen a short description of the example
%             and then quit (no output.)
%
% When no input is given, it should provide the structure Output ---- with the
% data needed for the plots. Output must have the fields:
%
% exa .......... String with example number.
% txt .......... String with brief description of the example.
% Nsl .......... Number of slides in example (MUST BE AT LEAST TWO.)
% Nbe .......... Number of branches that the envelope of rays/caustic has.
% xmin ......... Lower axis limit for x.
% xmax ......... Upper axis limit for x.
% ymin ......... Lower axis limit for y.
% ymax ......... Upper axis limit for y.
% zmin ......... Lower axis limit for z.
% zmax ......... Upper axis limit for z.
% ver .......... 2 by 1 array with the default view for the 3-D plots.
% X ............ Length Nsl cell array.  X{n} = array of x-coordinates for the
%                wavefront at a time t = T(n).
% Y ............ Length Nsl cell array.  Y{n} = array of y-coordinates for the
%                wavefront at a time t = T(n).
% Z ............ Length Nsl cell array.  Z{n} = array of z-coordinates for the
%                wavefront at a time t = T(n).
% T ............ 1 by Nsl array. Times the wave-front was computed. T(1) = 0.
% Xe ........... Length Nbe cell array. Xe{n} = x-coordinates for branch n of
%                the envelope of rays.
% Ye ........... Length Nbe cell array. Ye{n} = y-coordinates for branch n of
%                the envelope of rays.
% Ze ........... Length Nbe cell array. Ze{n} = z-coordinates for branch n of
%                the envelope of rays.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-27-2001.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
exa = 'Example 04.';
txt = 'Focusing paraboloid, t=0 wave-front: z = 1.75 x^2 + 2.00 y^2.';
a    = 1.75;% --- Write equation as z = a*x^2+b*y^2.
b    = 2.00;% --- Write equation as z = a*x^2+b*y^2.
Nsl  =   18;% --- Number of times to plot wave-front, including t = 0.
t_f  = 1.70;% --- Final time to compute wave-front.
xmin = - 1.00;
xmax = + 1.00;
ymin = - 1.00;
ymax = + 1.00;
zmin = - 0.05;
zmax = + 1.95;
ver  = [40, 70];% --- Select viewpoint.
%
if nargin == 1
   if N == 0;   fprintf(['\n --- ', exa, ' ', txt]);   end;   return
end
%
% --- Make wave-fronts.
%
smax = 1.30;   smin = - smax;
s = smin + (smax-smin)*(0:200)/200;% --- parameter for wave-fronts.
rmax = 1.30;   rmin = - smax;
r = rmin + (rmax-rmin)*(0:200)/200;% --- parameters for wave-fronts.
T = t_f*(0:Nsl-1)/(Nsl-1);% ------------ times for wave-fronts.
%
S = (s')*ones(size(r));
R = ones(size(s'))*r;
D = 1./(sqrt(1 + 4*(a^2)*(S.^2) + 4*b^2*(R.^2)));
clear r s
%
for n=1:Nsl
   x = (1 - 2*a*T(n)*D).*S;
   J = find((x > xmax) | (x < xmin));   x(J) = Inf;   X{n} = x;   clear x
   y = (1 - 2*b*T(n)*D).*R;
   J = find((y > ymax) | (y < ymin));   y(J) = Inf;   Y{n} = y;   clear y
   z = a*(S.^2) + b*(R.^2) + T(n)*D;
   J = find((z > zmax) | (z < zmin));   z(J) = Inf;   Z{n} = z;   clear z
end
%
% --- Make envelope.
%
A = (a + b + 4*a*b*(b*(R.^2) + a*(S.^2)))/(4*a*b);
B = (1 + 4*(b^2)*(R.^2) + 4*(a^2)*(S.^2))/(4*a*b);
%
Nbe = 0;
%
u = A + sqrt(A.^2 - B);
x = (1 - 2*a*u).*S;
J = find((x > xmax) | (x < xmin)); x(J) = Inf; Xe{1} = x;   clear x
y = (1 - 2*b*u).*R;
J = find((y > ymax) | (y < ymin)); y(J) = Inf; Ye{1} = y;   clear y
z = a*(S.^2) + b*(R.^2) + u;
J = find((z > zmax) | (z < zmin)); z(J) = Inf; Ze{1} = z;   clear z
Nbe = Nbe + 1;
%
u = A - sqrt(A.^2 - B);
x = (1 - 2*a*u).*S;
J = find((x > xmax) | (x < xmin)); x(J) = Inf; Xe{2} = x;   clear x
y = (1 - 2*b*u).*R;
J = find((y > ymax) | (y < ymin)); y(J) = Inf; Ye{2} = y;   clear y
z = a*(S.^2) + b*(R.^2) + u;
J = find((z > zmax) | (z < zmin)); z(J) = Inf; Ze{2} = z;   clear z
Nbe = Nbe + 1;
% ____________________________________________________________________________
% --- Store stuff for output. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Output.xmin = xmin;   Output.exa = exa;   Output.X  = X;
Output.xmax = xmax;   Output.txt = txt;   Output.Y  = Y;
Output.ymin = ymin;   Output.Nsl = Nsl;   Output.Z  = Z;
Output.ymax = ymax;   Output.Nbe = Nbe;   Output.Xe = Xe;
Output.zmin = zmin;   Output.ver = ver;   Output.Ye = Ye;
Output.zmax = zmax;   Output.T   = T;     Output.Ze = Ze;
%
if nargout == 0; clear Output; end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF


