% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% movieBDIBS
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Produce a movie illustrating the solution of u_t + 0.5 * (u^2)_x = 0, shocks
% included. Periodic boundary conditions are used. 
% Uses iniconBDIBS and backdiff_IBS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-25-1999.
% Update     by Rodolfo R. Rosales  02-05-2005.
% Update     by Rodolfo R. Rosales  02-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
figure
whitebg('k')
fprintf('\n Make the current figure window small, else you may run out of')
fprintf('\n memory. Then strike any key to continue. \n')
pause
%%%%%%%% PARAMETERS FOR MOVIE. CAN BE CHANGED! %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
a = 0;           % Left end of period interval.
b = 2;           % Right end of period interval.
flag = 1;        % Choice of initial conditions in inicon.
Nframes = 150;   % Number of frames in movie.                 Try: 150
Nspace  = 500;   % Number of points in space grid.            Try: 500
t_f     = 4.0;   % Total time-length of movie, in period
%                %              travel times for wave.        Try: 3.0
Nplays  = 0;     % Movie will be played (Nplays + 1) times.
FPS = 10;        % Frames per second for movie.
Par(1) = 1;      % For flag = 1: mean of wave                 Try: 1.0
Par(2) = 0.5;    % For flag = 1: wave first harmonic.         Try: 0.5
Par(3) = 0.4;    % For flag = 1: wave second harmonic.        Try: 0.4
%
[u0, x, dx] = iniconBDIBS(Nspace, a, b, Par, flag);
umax = max(u0);
t1 = t_f*(b-a)/umax/150;   % Time advance between frames. %%%%%%%%%%%%%%%%%%%%
u  = u0;
t  = 0;
Mv = moviein(Nframes);     % Reserves space in memory for movie. %%%%%%%%%%%%%
fprintf('\n Now we make the movie; frame by frame.\n')
for n=1:Nframes
    plot(x, u, '-c','LineWidth',3)
    axis([a b 0 umax])
    NTEXT = num2str(t);
    title('Solution to u_t + 0.5*(u^2)_x = 0.', ...
          'FontName', 'HelveticaNarrowBold', 'FontSize', 20)
    ylabel('u(x, t)', 'FontName', 'HelveticaNarrowBold', 'FontSize', 18)
    xlabel('x', 'FontName', 'HelveticaNarrowBold', 'FontSize', 18)
    text(1.0, 0.2, ['Time = ', NTEXT], ...
         'FontName', 'HelveticaNarrowBold', 'FontSize', 18)
    Mv(:,n) = getframe;    % Gets figure as a frame in movie. %%%%%%%%%%%%%%%%
    u = backdiff_IBS(u, t1, dx);
    t = t+t1;
end
fprintf('\n Movie done. Press any key to see it now. \n')
pause
movie(Mv,Nplays,FPS)       % plays movie back. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
fprintf('\n Movie is stored in the array Mv. \n')
fprintf('\n To play movie n times, type: movie(Mv, n).\n')
fprintf('\n Bye. \n')
fprintf('\n')
clear FPS  Nplays  a  flag  t_f  umax  Nspace NTEXT
clear b  n  u  x  Nframes  Par  dx  t1  u0  t     
%
%% END OF FILE
 
