function AddToPath311Toolkit % Add to MatLab path the 18311 MatLab toolkit.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% To use the MatLab 18311 Toolkit:
% 1) Put the MatLab18311Toolkit folder somewhere in your computer.
% 2) Edit the first line of this script, and write there the path to the
%    MatLab18311Toolkit folder, as placed in step 1.
% 3) Put this script somewhere in the MatLab path
%    --- the MatLab main directory, for example.
%
% Now you are ready to use the MatLab 18311 Toolkit.
% Executing this script will add to the MatLab path the 18311 scripts.
%
% Copyright at the end of this file.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
DirPath = 'MyComputer/Users/Myself/desktop/MatLab18311Toolkit';
%
% DirPath = path to the directory with the 18311 MatLab Toolkit
%
% Example:
% DirPath = 'MyComputer/Users/Myself/desktop/MatLab18311Toolkit';
%
S = filesep;
%
if exist(DirPath) == 7;   addpath(DirPath, '-end');   end
N = 0;
N = N+1; SubDirPathList{N} = [DirPath, S, 'BackDiff_IBS'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Car_Following_Simple_Model'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Envelopes_Caustics'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Envelopes_Caustics', S, 'EIKO3Dexamples'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Envelopes_Caustics', S, 'EIKOexamples'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Heat_FT'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Problem_Sets'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Support'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Wave_Breaking'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Wave_Breaking', S, 'demoWBRch_v03_f'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Wave_eqnGBNS'];
N = N+1; SubDirPathList{N} = [DirPath, S, 'Wave_eqnGBNS', S, 'GBNS_lecture'];
%
for n=1:N
   SubDirPath = SubDirPathList{n};
   if exist(SubDirPath) == 7;   addpath(SubDirPath, '-end');   end
end
%
disp(' For the 18311_Toolkit ........ contents, type:  help 311TC')
disp('                                details,  type:  help 18311')

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% EOF
