% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% readmeGBNS 
%            Contents of directory Wave_eqnGBNS.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% The scripts here deal with the question of Numerical Stability of schemes to
% solve PDE's.   In particular, two schemes are implemented and tested for the
% wave equation u_tt - u_xx = 0. See the help for InitGBNS or run lectureGBNS,
% or GBNS_lecture.
% For more information see the notes (in the 18.311 WEB page):
%                 "Stability of Numerical Schemes for PDE's"
% either in postscript or pdf form.
%
% SCRIPTS ____________________________________________________________________
%
% lectureGBNS .... Demo that introduces the subject matter.
% demoGBNS   ..... Demo showing a couple of example solutions of the wave eqn.
% InitGBNS ....... Function script implementing the two numerical schemes, and
%                  two choices of numerical conditions.
% movieGBNS ...... Function script to make movies with the output of InitGBNS.
% movieGBNS_NOTES. Help script: detailed explanations of how movieGBNS works.
%
% GBNS_lecture ... A more elaborate version of lectureGBNS, but with basically
%                  the same contents.
%                  Calls many other scripts, as GBNS_lecture_Readme explains.
%                  GBNS_lecture_2D .......... subscript of GBNS_lecture.
%                  GBNS_lecture_3D .......... subscript of GBNS_lecture.
%                  GBNS_lecture_Compute ..... subscript of GBNS_lecture.
%                  GBNS_lecture_FIG ......... subscript of GBNS_lecture.
%                  GBNS_lecture_FIG_var ..... subscript of GBNS_lecture.
%                  GBNS_lecture_HELP ........ subscript of GBNS_lecture.
%                  GBNS_lecture_Movie ....... subscript of GBNS_lecture.
%                  GBNS_lecture_MSG1 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_MSG2 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_MSG3 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_Readme ...... subscript of GBNS_lecture.
%                  GBNS_lecture_RESET ....... subscript of GBNS_lecture.
%                  GBNS_lecture_SEL ......... subscript of GBNS_lecture.
% GBNS_GScheme ... Solves arbitray initial value problems, with periodic
%                  boundary conditions.
%
% NOTES: _____________________________________________________________________
%
% The files in this directory are scripts to solve the wave equation
% 
%     u_tt - u_xx = 0,  written in the form     u_t = v,   v_t = u_xx,
%                                                           
% with periodic boundary conditions in x, using uniform meshes  x_j = x_0+j*dx
% and t_n = n*dt.
%
%                Description of the two example algorithms used.
%
% For any function of x, f = f(x): let f2 = f(x+dx) + f(x-dx) - 2*f(x).   Then
% f2/dx is an approximation to the second derivative f'' - with error O(dx^2).
% The algorithms used (second order in space, first order in time) are then:
%
%      u(x,t+dt) = u(x,t) +  v(x,t)*dt        + u2(x,t)*(dt/dx)^2,
%                                               ^^^^^^^^^^^^^^^^^
%      v(x,t+dt) = v(x,t) + u2(x,t)*(dt/dx^2) + v2(x,t)*(dt/dx)^2,
%                                               ^^^^^^^^^^^^^^^^^
% where:  the underlined terms are not included in the 'B' (bad) scheme choice
%         in InitGBNS, and are included in the 'G' (good) scheme choice.
%
% The 'B' algorithm is not stable --- von Neuman stability analysis.   But the
% 'G' scheme is stable as long as:  dt <= 0.5 * dx.   NOTE though that this IS
% NOT a "good" algorithm --- in the sense that it is quite far from  "state of
% the art" --- but it is very simple and serves to illustrate important ideas.
% Note that is has some "strange" terms added (undelined), whose purpose is to
% correct the badly behaved 'B' algorithm (which is naively intuitive).  These
% terms introduce numerical dissipation  (used to kill the badly growing modes
% the 'B' scheme has).   This dissipation goes to zero as dx vanishes, but too
% slowly.  Thus, for "practical size" dx the scheme has way too much numerical
% dissipation --- which result into loosing a lot of the energy present in the
% initial conditions. The script lectureGBNS illustrates some of these points.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
more on
help readmeGBNS
more off
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-15-2001.
% Update     by Rodolfo R. Rosales  02-25-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
