% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% movieGBNS_NOTES.  Notes on how the script movieGBNS works.                 .
%                                                                            .
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%                                                                            .
% CONTENTS:                                                                  .
% @01 --- Fields of the global variable global_MovieGBNS_choose.             .
% @02 --- The MovieGBNS_choose script.  Demo mode: how it works, what it does.
% @03 --- The MovieGBNS_choose script.  Details of how it works.             .
% @04 --- Overall description of how movieGBNS works.                        .
%                                                                            .
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% @01 --- Fields of the global variable global_MovieGBNS_choose.             .
%         Variable defined (and used) by sub-script MovieGNBS_choose.        .
%                                                                            .
% HANDLES:                                                                   .
% fcons ....... CONTROL FIGURE.                                              .
% fmovie ...... MOVIE FIGURE.                                                .
% h1 .......... radio button. ON ==> INIVAL = 'G', OFF ==> INIVAL = 'C'.     .
% h2 .......... radio button. ON ==> INIVAL = 'C', OFF ==> INIVAL = 'G'.     .
% h3 .......... edit window to select value of a.                            .
% h4 .......... radio button. ON ==> SCHEME = 'G', OFF ==> SCHEME = 'B'.     .
% h5 .......... radio button. ON ==> SCHEME = 'B', OFF ==> SCHEME = 'G'.     .
% h6 .......... edit window to select value of t_f.                          .
% h7 .......... edit window to select value of N.                            .
% h8 .......... edit window to select value of Nframes.                      .
% h9 .......... edit window to select value of FPS.                          .
% h10 ......... "Make movie" button (also "New movie?")                      .
% h11 ......... "Play movie" button.                                         .
% h12 ......... "Help" button.                                               .
% h13 ......... "Quit" button.                                               .
% PARAMETERS:                                                                .
% INIVAL ...... Initial values used: 'G' ==> GAUSSIAN, 'C' ==> COSINE.       .
%               DEFAULT: INIVAL = 'G'.                                       .
% a ........... Parameter in initial values, POSITIVE.                       .
%               DEFAULT: a = 1.000.                                          .
% SCHEME ...... Numerical scheme used: 'G' ==> GOOD, 'B' ==> BAD.            .
%               DEFAULT: SCHEME = 'G'.                                       .
% t_f ......... Compute for 0 <= t <= t_f.                                   .
%               DEFAULT: t_f = 2.000.                                        .
% N ........... Number of points in space grid.                              .
%               DEFAULT: N = 50.                                             .
% Nframes ..... Number of frames in movie.                                   .
%               DEFAULT: Nframes = 25.                                       .
% FPS ......... Frames Per Second.                                           .
%               DEFAULT: FPS = 12.                                           .
% Mv .......... Variable with movie stored.                                  .
%                                                                            .
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% @02 --- The MovieGBNS_choose script.  Demo mode: how it works, what it does.
%                                                                            .
% This subscript is the one that runs the whole show -- while in the demo mode
% of operation. This is done by:                                             .
%                                                                            .
%   FIRST ... Create a CONTROL FIGURE, with buttons of various types to select
%             parameter values, make and run the movie, etc.                 .
%             --- On creation all parameters are assigned default values.    .
%             --- The button handles and default values are stored in a global
%                 variable named: global_MovieGBNS_choose.                   .
%             --- If the global_MovieGBNS_choose exists in the workspace,  the
%                 checks it to assign the parameter values it has, if any, NOT
%                 the defaults.                                              .
%   SECOND .. From the control figure, the various buttons call the script ---
%             with the appropriate inputs, to execute the various actions.   .
%                                                                            .
% General idea of HOW THE DEMO MODE OF OPERATION RUNS/HOW TO START IT.       .
%                                                                            .
%   The DEMO MODE OF OPERATION OCCURS WHEN:                                  .
%   --- movieGBNS is called without no no arguments.                         .
%   --- Then movieGBNS calls MovieGBNS_choose without inputs and quits.      .
%   --- This sets up the CONTROL FIGURE and the global variable.             .
%   --- Later calls from the CONTROL FIGURE call movieGBNS with one input.   .
%   --- Then movieGBNS calls MovieGBNS_choose with the given input, and quits.
%   --- MovieGBNS_choose executes the appropriate action.                    .
%   --- The global variable global_MovieGBNS_choose stores needed values, that
%       are needed to execute the various runs.                              .
%                                                                            .
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% @03 --- The MovieGBNS_choose script. Details of how it works.              .
%                                                                            .
% In each case, check if a value is defined by a pre-existing global variable,
% before setting it to default.                                              .
%                                                                            .
% Store handles and values in the global variable global_MovieGBNS_choose.   .
%                                                                            .
% Use field names as the local variable name while working with the data.    .
%                                                                            .
% For nargin = 0                                                             .
%                                                                            .
%    a01 --- Create control figure (delete old one if there is one.) Write the
%            "title" and store the handle in global_MovieGBNS_choose.fcons.  .
%    a02 --- Create (exclusive) radio buttons (2) to select initial values.  .
%            Button with handle h1  ... If on; INIVAL = 'G' (GAUSSIAN.)      .
%            Button with handle h2  ... If on; INIVAL = 'C' (COSINE.)        .
%            DEFAULT IS: INIVAL = 'G'.                                       .
%    a03 --- Create edit window to select value of a (handle h3).            .
%            DEFAULT IS: a = 1.000.                                          .
%    a04 --- Create (exclusive) radio buttons (2) to select scheme.          .
%            Button with handle h4  ... If on; SCHEME = 'G' (GOOD.)          .
%            Button with handle h5  ... If on; SCHEME = 'B' (BAD.)           .
%            DEFAULT IS: SCHEME = 'G'.                                       .
%    a05 --- Create edit window to select value of t_f (handle h6.)          .
%            DEFAULT IS: t_f = 2.000.                                        .
%    a06 --- Create edit window to select value of N (handle h7.)            .
%            DEFAULT IS: N = 50.                                             .
%    a07 --- Create edit window to select value of Nframes (handle h8.)      .
%            DEFAULT IS: Nframes = 25.                                       .
%    a08 --- Create edit window to select value of FPS (handle h9.)          .
%            DEFAULT IS: FPS = 12.                                           .
%    a09 --- Create "Make movie" button (handle h10.)                        .
%    a10 --- Create "Play movie" button (handle h11.)                        .
%            Make visible only if there is a movie to play.                  .
%    a11 --- Create "Help" button (handle h12.)                              .
%    a12 --- Create "Quit" button (handle h13.)                              .
%                                                                            .
% For nargin = 1  (actions executed when a button is pushed, etc.)           .
%                                                                            .
%    b01 (n = 1) --- Select Initial Value = Gaussian.  Set INIVAL = 'G'.     .
%    b02 (n = 2) --- Select Initial Value = Cosine.    Set INIVAL = 'C'.     .
%    b03 (n = 3) --- Enter value of a in edit window.                        .
%    b04 (n = 4) --- Select good scheme. Set SCHEME = 'G'.                   .
%    b05 (n = 5) --- Select bad  scheme. Set SCHEME = 'B'.                   .
%    b06 (n = 6) --- Enter value of t_f       in edit window.                .
%    b07 (n = 7) --- Enter value of N         in edit window.                .
%    b08 (n = 8) --- Enter value of Nframes   in edit window.                .
%    b09 (n = 9) --- Enter value of FPS       in edit windoe.                .
%    b10 (n = 10) -- Make movie. If movie figure does not exist, create it.  .
%                    Movie figure handle: global_MovieGBNS_choose.fmovie.    .
%                    Store movie in: global_MovieGBNS_choose.Mv.             .
%                    Creating the movie involves:                            .
%                    --- Calling InitGBNS to calculate the solution          .
%                    --- Call movieGBNS with arguments (not in demo mode) to .
%                        do the movie.                                       .
%                    Make "Play movie" button visible.                       .
%                    At end, put CONTROL FIGURE into foreground.             .
%                                                                            .
%                    NOTE movieGBNS (when called in the manual mode by the n =
%                    9 action)  can "tell" it is being called from the control
%                    figure (and skip screen messages that occur in the manual
%                    mode) because the input FigNumber is negative -- the abs.
%                    value is used for the figure.                           .
%                                                                            .
%                    Finally: AFTER making the movie,  the "Make movie" button
%                    is turned into the "New movie?" button,   and all entries
%                    that allow parameter changes are disabled.  Then:       .
%         n = 10.5   allows the "New movie?" button to enable things back so a
%                    new movie can be made.                                  .
%                                                                            .
%    b11 (n = 11) -- Play movie.                                             .
%                    First put movie figure into foreground.                 .
%                    Then play the movie.                                    .
%                    At end, put CONTROL FIGURE into foreground.             .
%    b12 (n = 12) -- Open help window.                                       .
%    b13 (n = 13) -- Close windows and delete global variable.               .
%                                                                            .
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% @04 --- Overall description of how movieGBNS works.                        .
%                                                                            .
% movieGBNS works in the straightforward way, if called in the manual mode ---
% arguments given. When no arguments are given, or only one is given, it gives
% control to MovieGNBS_choose, passing the argument (if any.) This sub-script:
% First creates the control window, and then executes the various actions that
% pushing buttons (etc.) in the control window require --- since these actions
% all call movieGBNS with a single argument.   Variable values that are needed
% to operate the scheme are stored in global_MovieGNBS_choose (global variable
% declared in MovieGNBS_choose.)                                             .
%                                                                            .
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-15-2001.
% Update     by Rodolfo R. Rosales  02-25-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF

