function GBNS_lecture_Movie
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture_Movie
%          Runs Movie like slide show during 2D picture mode.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
fgN = global_GBNS_lect_FigPar.fgN;
Hbt = global_GBNS_lect_FigPar.Hbt;
Hdp = global_GBNS_lect_FigPar.Hdp;
Hax = global_GBNS_lect_FigPar.Hax;
Hsl = global_GBNS_lect_FigPar.Hsl;
Nbt = length(Hbt);
%
% --- Set window for displaying current time in movie.
%
PAx = get(Hax, 'Position');
COL = get(fgN, 'Color');
PTw = [PAx(1)+0.45*PAx(3), PAx(2)+1.04*PAx(4), 0.60*PAx(3), 0.08*PAx(4)];
HTw = uicontrol('Style',           'Text', ...
                'Units',           'normalized', ...
                'Position',         PTw, ...
                'String',           '2.0000', ...
                'BackgroundColor',  COL, ...
                'ForegroundColor',  'w', ...
                'Visible',          'on', ...
                'FontWeight',       'Bold', ...
                'FontUnits',        'Normalized', ...
                'FontSize',          0.70);
%
% --- Record current Enable's and turn off everything but slider.
%
for n=1:Nbt
   Enable{n} = get(Hbt(n), 'Enable');
   set(Hbt(n), 'Enable', 'off')
end
%
% --- Get Max and Min and Callback from slider. Then turn off CallBack,
%     so slider plotting does not interefere with movie.
%
Min = round(get(Hsl, 'Min'));
Max = round(get(Hsl, 'Max'));
CBK = get(Hsl, 'Callback');
set(Hsl, 'Callback', '');
%
% --- Get Part we are at from button 4 string (says Quit P#)
%
String = get(Hbt(4), 'String');
Part   = String(1, 7);
%
n    = round(get(Hbt(2), 'UserData'));
%
eval(['global global_GBNS_lect_Part_', Part])
eval(['N    = global_GBNS_lect_Part_', Part, '{n}.N;'])
eval(['a    = global_GBNS_lect_Part_', Part, '{n}.a;'])
eval(['t_f  = global_GBNS_lect_Part_', Part, '{n}.t_f;'])
eval(['x    = global_GBNS_lect_Part_', Part, '{n}.x;'])
eval(['T    = global_GBNS_lect_Part_', Part, '{n}.T;'])
eval(['U    = global_GBNS_lect_Part_', Part, '{n}.U;'])
eval(['V    = global_GBNS_lect_Part_', Part, '{n}.V;'])
eval(['M    = global_GBNS_lect_Part_', Part, '{n}.M;'])
eval(['umin = global_GBNS_lect_Part_', Part, '{n}.umin;'])
eval(['umax = global_GBNS_lect_Part_', Part, '{n}.umax;'])
%
axes(Hax)
cla
rotate3d off
axis([-1 1 -0.5 1.5])
set(Hax, 'Visible',    'on', ...
         'FontUnits',  'Normalized', ...
         'FontWeight', 'Bold', ...
         'FontSize',    0.05, ...
         'LineWidth',   1)
hold on
grid on
%
xlabel('{\bf x}', 'FontUnits', 'Normalized', 'FontSize',   0.07)
ylabel('')
title('')
text('String',              '{\bf u}', ...
     'Units',               'Normalized', ...
     'Position',             [1.02, 0.5], ...
     'HorizontalAlignment', 'left', ...
     'Rotation',             0, ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String',              '{\bf u = u(x, t)}', ...
     'Units',               'Normalized', ...
     'Position',             [0.25, 1.07], ...
     'HorizontalAlignment', 'center', ...
     'Rotation',             0, ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
%
n = 1;
while n <= Max
   set(Hsl, 'Value', n)
   if n > 1; delete(Hline); delete(Hmark); end
   Hline = line(x, U(n, :), 'LineStyle',   '-', ...
                            'Color',       'c', ...
                            'LineWidth',    2,  ...
                            'EraseMode',   'xor');
   Hmark = line(x, U(n, :), 'Marker',      '.', ...
                            'Color',       'c', ...
                            'MarkerSize',   9,  ...
                            'EraseMode',   'xor');
   NRES = num2str(T(n), '%6.4f');
   set(HTw, 'String', ['t = ', NRES])
   drawnow
   mi_pausa(0.08)
   n = 1 + round(get(Hsl, 'Value'));
end
%
hold off
%
set(Hsl, 'Callback', CBK); % Set slider callback to what it was.
delete(HTw);               % Delete time window.
%
% --- Reset all Enable's and "reset view" button.
%
for n=1:Nbt; set(Hbt(n), 'Enable', Enable{n}); end
set(Hbt(5), 'Enable', 'off')
drawnow
GBNS_lecture_2D(str2num(Part)) % "Hard" plot current plot.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

function mi_pausa(t)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% Similar to pause(n), except that it accepts fractional second inputs. But it
% does not have the other functions of pause.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
t  = max(t-0.001, 0.002);
t0 = clock;
while etime(clock, t0) < t; end
% 
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
