function GBNS_lecture_2D(Part)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function GBNS_lecture_2D(Part)
%      Display 2D pictures, called by slider.
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-12-2001.
% Update     by Rodolfo R. Rosales  01-20-2005.
% Update     by Rodolfo R. Rosales  02-20-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
global global_GBNS_lect_FigPar
Hsl = global_GBNS_lect_FigPar.Hsl;
Hbt = global_GBNS_lect_FigPar.Hbt;
Hdp = global_GBNS_lect_FigPar.Hdp;
Hax = global_GBNS_lect_FigPar.Hax;
%
% --- PART 1 *****************************************************************
%
if Part == 1
   global global_GBNS_lect_Part_1
   n   = get(Hbt(2), 'UserData');
   N    = global_GBNS_lect_Part_1{n}.N;    % N    = [40 50 55 57 60 80].
   a    = global_GBNS_lect_Part_1{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_1{n}.t_f;  % t_f  = 2.
   x    = global_GBNS_lect_Part_1{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_1{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_1{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_1{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_1{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_1{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_1{n}.umax; % u maximum for axes.
   %
   val = round(get(Hsl, 'Value'));
   if val > M; val = M; end
   if val < 1; val = 1; end
   set(Hsl, 'Value', val)
   %
   axes(Hax)
   cla
   rotate3d off
   axis([-1 1 -0.5 1.5])
   set(Hax, 'Visible',    'on', ...
            'FontUnits',  'Normalized', ...
            'FontWeight', 'Bold', ...
            'FontSize',    0.05, ...
            'LineWidth',   1)
   hold on
   grid on
   %
   plot(x, U(val, :), '-c', 'LineWidth', 2)
   NRES = num2str(T(val), '%6.4f');
   title(['{\bf u = u(x, t),  t = ', NRES, '}'], ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   xlabel('{\bf x}', ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   ylabel('')
   text(...
          'String',              '{\bf u}', ...
          'Units',               'Normalized', ...
          'Position',             [1.02, 0.5], ...
          'HorizontalAlignment', 'left', ...
          'Rotation',             0, ...
          'FontUnits',           'Normalized', ...
          'FontSize',             0.07)
   hold off
   %
   % --- Set reset view button.
   %
   set(Hbt(5), 'Enable', 'off')
   % set(Hbt(6), 'Enable', 'off')
   %
end
%
% --- PART 2 *****************************************************************
%
if Part == 2
   global global_GBNS_lect_Part_2
   n   = get(Hbt(2), 'UserData');
   N    = global_GBNS_lect_Part_2{n}.N;    % N    = 100.
   a    = global_GBNS_lect_Part_2{n}.a;    % a    = [15 10  7  6  5  4].
   t_f  = global_GBNS_lect_Part_2{n}.t_f;  % t_f  = 0.5.
   x    = global_GBNS_lect_Part_2{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_2{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_2{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_2{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_2{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_2{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_2{n}.umax; % u maximum for axes.
   %
   val = round(get(Hsl, 'Value'));
   if val > M; val = M; end
   if val < 1; val = 1; end
   set(Hsl, 'Value', val)
   %
   axes(Hax)
   cla
   rotate3d off
   axis([-1 1 -0.5 1.5])
   set(Hax, 'Visible',    'on', ...
            'FontUnits',  'Normalized', ...
            'FontWeight', 'Bold', ...
            'FontSize',    0.05, ...
            'LineWidth',   1)
   hold on
   grid on
   %
   plot(x, U(val, :), '-c', 'LineWidth', 2)
   NRES = num2str(T(val), '%6.4f');
   title(['{\bf u = u(x, t),  t = ', NRES, '}'], ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   xlabel('{\bf x}', ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   ylabel('')
   text(...
          'String',              '{\bf u}', ...
          'Units',               'Normalized', ...
          'Position',             [1.02, 0.5], ...
          'HorizontalAlignment', 'left', ...
          'Rotation',             0, ...
          'FontUnits',           'Normalized', ...
          'FontSize',             0.07)
   hold off
   %
   % --- Set reset view button.
   %
   set(Hbt(5), 'Enable',   'off')
   % set(Hbt(6), 'Enable',   'off')
   %
end
%
% --- PART 3 *****************************************************************
%
if Part == 3
   global global_GBNS_lect_Part_3
   n   = get(Hbt(2), 'UserData');
   N    = global_GBNS_lect_Part_3{n}.N;    % N    = [40 50 55 57 60 80 160].
   a    = global_GBNS_lect_Part_3{n}.a;    % a    = 1.
   t_f  = global_GBNS_lect_Part_3{n}.t_f;  % t_f  = 2.
   x    = global_GBNS_lect_Part_3{n}.x;    % space mesh in [-1 1], dx = 2/N;
   T    = global_GBNS_lect_Part_3{n}.T;    % computed times M by 1 array
   U    = global_GBNS_lect_Part_3{n}.U;    % computed u     M by N array
   V    = global_GBNS_lect_Part_3{n}.V;    % computed v     M by N array
   M    = global_GBNS_lect_Part_3{n}.M;    % number of time slices.
   umin = global_GBNS_lect_Part_3{n}.umin; % u minimum for axes.
   umax = global_GBNS_lect_Part_3{n}.umax; % u maximum for axes.
   %
   val = round(get(Hsl, 'Value'));
   if val > M; val = M; end
   if val < 1; val = 1; end
   set(Hsl, 'Value', val)
   %
   axes(Hax)
   cla
   rotate3d off
   axis([-1 1 -0.5 1.5])
   set(Hax, 'Visible',    'on', ...
            'FontUnits',  'Normalized', ...
            'FontWeight', 'Bold', ...
            'FontSize',    0.05, ...
            'LineWidth',   1)
   hold on
   grid on
   %
   plot(x, U(val, :), '-c', 'LineWidth', 2)
   NRES = num2str(T(val), '%6.4f');
   title(['{\bf u = u(x, t),  t = ', NRES, '}'], ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   xlabel('{\bf x}', ...
          'FontUnits', 'Normalized', ...
          'FontSize',   0.07)
   ylabel('')
   text(...
          'String',              '{\bf u}', ...
          'Units',               'Normalized', ...
          'Position',             [1.02, 0.5], ...
          'HorizontalAlignment', 'left', ...
          'Rotation',             0, ...
          'FontUnits',           'Normalized', ...
          'FontSize',             0.07)
   hold off
   %
   % --- Set reset view button.
   %
   set(Hbt(5), 'Enable', 'off')
   % set(Hbt(6), 'Enable',   'off')
   %
   %
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
