% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% evolveWBRch
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Script to evolve initial data, following the characteristics of the equation
%
%                       u_t + c(u)*u_x = 0,
% 
% even beyond wave breaking --- when solution becomes multiple valued.
%
% ASSUMES that 3 arrays of equal size (1 x Ne):   F, G and eta  --- which WILL
% NOT BE ALTERED --- are already defined.
%
% The initial data (u(eta,0)=F(eta)) are given by F and eta
%                           --- Note that eta need not be equally spaced!
%                                         ^^^^^^^^^^^^^
% Further G = c(F), gives the characteristic speeds for the initial data.
%
% Then, in a given interval 0 < t < t_f,  it constructs (& PLOTS) the solution
% u(x,t)
%
%                u = F(eta)        x = G(eta)*t + eta
%
% The output is organized as follows:
% 
% xs ............. NtxNe array of x's with each row a time slice.
% us ............. NtxNe array of u's """""""""""""""""""""""""""
% ts ............. Ntx1 array of t's (times).
% xmax  xmin ..... maximum and minimum values of x.
% umax  umin ..... """"""""""""""""""""""""""""" u.
% t_f ............ final time computed.
% dt ............. time step: ts(n) = (n-1)*dt, with (Nt-1)*dt = t_f.
% Nt Ne........... number of times (Nt) and points in space (Ne).
%
% NOTE: t_f and Nt are requested via screen input, but internally the code may
%       adjust Nt (upwards) to make the time spacing between "slides" equal.
% THUS: on output Nt may not be equal to the screen input.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% This  version by Rodolfo R. Rosales  02-24-1999
% Update        by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
fprintf('\n NOTE: this script assumes that you have already defined 3 row ')
fprintf('\n       arrays F, G & eta of EQUAL length. See HELP for details.\n')
%
Ne  = size(eta); Ne = Ne(2);
%
t_f = input('Final time of calculation .......................... t_f = ');
Nt  = input('Number of times, including 0 & t_f, to compute ..... Nt = ');
Ns  = input('Number of times, including 0 & t_f, in Slide Show .. Ns = ');
%
Ns = max(2, Ns);
Nt = max(Ns, Nt);
Nskip = ceil((Nt-1)/(Ns-1));
Nt = 1 + (Ns-1)*Nskip;
%
dt  = t_f/(Nt-1);
ts  = (0:dt:t_f)';
UNO = ones(Nt, 1);
xs  = ts*G + UNO*eta;
us  = UNO*F;
%
xmax = max(max(xs)); xmin = min(min(xs));
umax = max(F);       umin = min(F);
%
HNB = 'HelveticaNarrowBold';
FS  = 'FontSize';
FN  = 'FontName';
LW  = 'LineWidth';
% ---------------------------------------------------------------- SLIDE Show.
fprintf('\n PRESS ANY KEY (& CONTINUE) to see the Slide Show. \n')
pause
figure
whitebg('k')
for m=1:Ns
   n = 1+(m-1)*Nskip;
   TIME = num2str(ts(n));
   plot(xs(n, :), F, '-c', LW, 3)
   axis([xmin xmax umin umax])
   grid on
   title('Your Problem', FN, HNB, FS, 18)
   xlabel(['Space x --- time is now  t = ', TIME], FN, HNB, FS, 16)
   ylabel('Solution  u', FN, HNB, FS, 16)
   if m < Ns
      pause
   end
end
fprintf('\n END of SLIDESHOW. \n')
fprintf('\n PRESS ANY KEY to see THREE D graph of solution. \n')
pause
% ---------------------------------------------------- TWO-D plot of solution.
figure
whitebg('k')
axis([xmin xmax 0 t_f umin umax])
hold on
title('Your Problem', FN, HNB, FS, 18)
xlabel('Space  x', FN, HNB, FS, 16)
ylabel('Time  t', FN, HNB, FS, 16)
zlabel('Solution  u', FN, HNB, FS, 16)
surf(xs, ts, us)
colormap(hsv)
shading interp
grid on
hold off
% ------------------------------------------------------------------ CLEAN UP.
clear  LW FN FS  HNB Ns Nskip TIME UNO m n
%
fprintf('\n THE END. \n')
%
%% END OF FILE
