function demoWBRch_v03_popup(Handle)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function demoWBRch_v03_popup(Handle)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% Executes the popup menu callback.
% Handle is the handle for the list box in the Help Window.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2002 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
UD = get(Handle, 'UserData');
%
% --- Update EXAMPLE number, and example data.
%
UD.EXAMPLE = get(UD.FigHWpopup, 'Value');
Output     = demoWBRch_v03_Example(UD.EXAMPLE);
UD.F         = Output.F;
UD.ts        = Output.ts;
UD.tmax      = Output.tmax;
UD.umax      = Output.umax;
UD.umin      = Output.umin;
UD.xs        = Output.xs;
UD.us        = Output.us;
UD.Nice_view = Output.Nice_view;
UD.TITL      = Output.TITL;
%
% --- Set up exist values for windows  (must do
%     so BEFORE any window redrawn, because the
%     new handle may be equal to that of a gone
%     window).
%
NotHandleFigSL = ~ishandle(UD.FigSL);
NotHandleFig3D = ~ishandle(UD.Fig3D);
%
% --- Check if Slider window still exists;
%     else, redraw it, and update UD (UserData).
%
if NotHandleFigSL
   [FigSL, FigSLslidr, FigSLmovie, FigSLexmpl, FigSLclose] = ...
         demoWBRch_v03_FigSL(Output, 'off');
   UD.FigSL      = FigSL;
   UD.FigSLslidr = FigSLslidr;
   UD.FigSLmovie = FigSLmovie;
   UD.FigSLexmpl = FigSLexmpl;
   UD.FigSLclose = FigSLclose;
end
%
% --- Check if 3D window still exists;
%     else, redraw it, and update UD (UserData).
%     Update plot.
%
if NotHandleFig3D
   Output.Vsbl = 'off';
   [Fig3D, Fig3Dexmpl, Fig3Dclose] = demoWBRch_v03_Fig3D(Output);
   UD.Fig3D      = Fig3D;
   UD.Fig3Dexmpl = Fig3Dexmpl;
   UD.Fig3Dclose = Fig3Dclose;
else
   demoWBRch_v03_Fig3D(Output, UD.Fig3D)
end
%
% --- Update UserData for buttons.
%
set(UD.Fig3Dexmpl, 'UserData', UD)
set(UD.FigSLexmpl, 'UserData', UD)
set(UD.FigHWexmpl, 'UserData', UD)
%
% --- Update stepping information for slider.
%
MXval = length(UD.ts);
set(UD.FigSLslidr,        ...
    'Value',      1,      ...
    'Max',        MXval,  ...
    'SliderStep', [1/(MXval-1), 0.2])
%
% --- Change labels in example buttons.
%
StrEx = ['Example #', num2str(UD.EXAMPLE, '%02.0f')];
set(UD.Fig3Dexmpl, 'String', StrEx)
set(UD.FigSLexmpl, 'String', StrEx)
%
% --- Update callbacks for buttons, slider, and popup menu.
%
Handles = [UD.FigSLexmpl, UD.Fig3Dexmpl, UD.FigHWexmpl];
HdlsTxt = ['[', num2str(Handles, '%37.30e'), ']'];
%
set(UD.FigSLslidr, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 0)'])
set(UD.FigSLexmpl, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 3)'])
set(UD.FigSLclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 4)'])
set(UD.Fig3Dexmpl, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 5)'])
set(UD.Fig3Dclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 6)'])
set(UD.FigHWclose, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 7)'])
if strcmp('Movie', get(UD.FigSLmovie, 'String'))
   set(UD.FigSLmovie, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 1)'])
else
   set(UD.FigSLmovie, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 2)'])
end
set(UD.FigHWpopup, 'CallBack', ['demoWBRch_v03(', HdlsTxt, ', 8)'])
%
% --- Update plot in FigSL and make hidden figures (if any) visible.
%
demoWBRch_v03_Slider(UD.FigSLexmpl)
set(UD.Fig3D, 'Visible', 'on')
set(UD.FigSL, 'Visible', 'on')
if NotHandleFigSL & ~NotHandleFig3D
   figure(UD.Fig3D)
   figure(UD.FigHW)
elseif ~NotHandleFigSL & NotHandleFig3D
   figure(UD.FigSL)
   figure(UD.FigHW)
elseif NotHandleFigSL & NotHandleFig3D
   figure(UD.Fig3D)
   figure(UD.FigSL)
   figure(UD.FigHW)
end
drawnow
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
