function demoWBRch_v03_movie(Handle)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function demoWBRch_v03_movie(Handle)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% Executes the Movie button callback.
% Handle is the handle for the Example button in the slider figure.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
UD = get(Handle, 'UserData');
%
% --- Reset Movie button to Stop button.
%
Handles = [UD.FigSLexmpl, UD.Fig3Dexmpl, UD.FigHWexmpl];
HdlsTxt = ['[', num2str(Handles, '%37.30e'), ']'];
CallBck = ['demoWBRch_v03(', HdlsTxt, ', 2)'];
set(UD.FigSLmovie, ...
   'String',           'Stop', ...
   'BackGroundColor',  'y',    ...
   'UserData',         1, ...
   'CallBack',         CallBck)
%
% --- Play movie.
%
Play = 1;
while Play == 1
   %
   % --- Movie stops if a Close button is pushed.
   %
   if ~ishandle(UD.FigSL); return; end
   %
   % --- Movie stops if Stop button is pushed.
   %
   Play = get(UD.FigSLmovie, 'UserData');
   %
   % --- Update slider value in cycles.
   %
   UD = get(Handle, 'UserData');
   value  = get(UD.FigSLslidr, 'Value') + 1;
   MXval  = get(UD.FigSLslidr, 'Max');
   if value > MXval
      value = 1;
      t0 = clock; while etime(clock, t0) < 0.75; end
   end
   set(UD.FigSLslidr, 'Value', value);
   %
   % --- Update plot.
   %
   demoWBRch_v03_Slider(UD.FigSLexmpl)
   t0 = clock; while etime(clock, t0) < 0.07; end
   drawnow
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
