function demoWBRch_v03_Slider(FigSLexmpl)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function demoWBRch_v03_Slider(FigSLexmpl)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% --- Makes 2D plot for current value of slider, in slider figure.
%
% FigSLexmpl is the handle for the example button in the slider figure.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
UD = get(FigSLexmpl, 'UserData');
n  = round(get(UD.FigSLslidr, 'Value'));
%
set(0, 'CurrentFigure', UD.FigSL)
hold off
plot(UD.xs(n, :), UD.F, '-c', 'LineWidth', 3)
hold on;
grid on;
zoom on;
set(gca, 'FontWeight', 'Bold', ...
         'FontSize',    16, ...
         'LineWidth',   2, ...
         'Box',         'on')
TIME = num2str(UD.ts(n), '%8.5f');
axis([0 2*pi UD.umin UD.umax])
title(['{\bf', UD.TITL, '}'], 'FontSize', 18)
xlabel('{\bf x }', 'FontSize', 20)
ylabel('{\bf u }', 'FontSize', 20, 'Rotation', 0, ...
       'HorizontalAlignment', 'right')
text('Units', 'Normalized', 'Position', [0.50, -0.15], ...
     'FontSize', 20, 'HorizontalAlignment', 'center', ...
     'String', ['{\bf Time t = ', TIME, '}'])
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
