function [FigSL, FigSLslidr, FigSLmovie, FigSLexmpl, FigSLclose] = ...
         demoWBRch_v03_FigSL(Output, Vsbl)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [FigSL, FigSLslidr, FigSLmovie, FigSLexmpl, FigSLclose] = ...
%          demoWBRch_v03_FigSL(Output, Vsbl)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% --- Makes the figure for the 2D plots.
% --- Returns the handles to the figure, slider and buttons.
% --- Sets up the starting message on the figure.
% --- NEITHER the UserData for the example button, NOR the CallBack
%     for any of the buttons or slider are set by the script.
%
% Here Output is as in demoWBRch_v03_Example
%
% Vsbl ....... can be either 'on', or 'off'. OPTIONAL; DEFAULT = 'on'.
%              Determines if figure is visible, or not.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Inpt.Name = 'Evolution of Solution in time.';
Inpt.Slid = 1;
Inpt.SldH = 0.05;
Inpt.Vsbl = 'off';
Inpt.valu = 1;
Inpt.mini = 1;
Inpt.maxi = length(Output.ts);
Inpt.step = [1/(length(Output.ts)-1), 0.2];
Inpt.cbck = 'disp(''No callback'')';
Inpt.dX = 0.07;
Inpt.dY = 0.20;
Inpt.fW = 0.70;
Inpt.fH = 0.70;
Inpt.aW = 0.70;
Inpt.aH = 0.70;
%
% --- Make figure and slider. ================================================
%
Otpt = demoWBRch_v03_MakeFig(Inpt);
   whitebg(Otpt.f, 'k')
   FigSL      = Otpt.f;
   FigSLslidr = Otpt.s;
%
% --- Movie button. ==========================================================
%
FigSLmovie = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'c', ...
             'Interruptible',   'on', ...
             'Units',           'Normalized', ...
             'Position',         [0.78 0.06 0.2 0.07], ...
             'UserData',         0, ...
             'String',           'Movie');
%
% --- Example button. ========================================================
%
StrEx = ['Example #', num2str(Output.EXAMPLE, '%02.0f')];
FigSLexmpl = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'r', ...
             'Interruptible',   'on', ...
             'Units',           'Normalized', ...
             'Position',         [0.02 0.06 0.34 0.07], ...
             'String',           StrEx);
%
% --- Close button. ==========================================================
%
FigSLclose = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'w', ...
             'Units',           'Normalized', ...
             'Position',         [0.04 0.95 0.15 0.04], ...
             'String',          'Close');
%
% --- Setup starting screen (with text, etc.). ===============================
%
text('Units',               'Normalized', ...
     'Position',             [0.50, 1.00], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'Use the slider to see the plots.')
%
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.80], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'Use the Movie/Stop button to')
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.70], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'start/stop')
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.60], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'the time evolution movie.')
%
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.40], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'Use the Example buttons to')
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.30], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'change to next example.')
%
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.10], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'Use the Close buttons to')
text('Units',               'Normalized', ...
     'Position',             [0.50, 0.00], ...
     'FontUnits',           'Normalized', ...
     'FontWeight',          'Bold', ...
     'FontSize',             0.09, ...
     'HorizontalAlignment', 'Center', ...
     'String',              'terminate the demo.')
%
axis off
if nargin == 1;
   set(FigSL, 'Visible', 'on')
else
   set(FigSL, 'Visible', Vsbl)
end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
