function [Fig3D, Fig3Dexmpl, Fig3Dclose] = demoWBRch_v03_Fig3D(Output, Fig3D)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function [Fig3D, Fig3Dexmpl, Fig3Dclose] = ...
%    demoWBRch_v03_Fig3D(Output, Fig3D)
% .................................................... Rosales, March. 2008.
% Part of demoWBRch_v03
%
% With 1 input:
% --- Makes the figure for the 3D plots.
% --- Returns the handles to the figure, example button and close button.
% --- Plots the current example (3D plot).
% --- NEITHER the UserData for the example button,
%     NOR the CallBack for the close button are set by the script.
%
% Here Output is as in demoWBRch_v03_Example
%
% With 2 inputs:
% --- Does the 3D plot in the figure with handle Fig3D.
% --- Returns Fig3Dexmpl = [], and Fig3Dclose = [].
%
% NOTE; Output can have an extra field:
% Output.Vsbl, with values 'on', or 'off'.
%          --- If present, this field overides the visibility of the figure.
%          --- If absent, figure is created visible (nargin == 1), and left
%              with visibility untouched.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 00 by Rodolfo R. Rosales  02-25-1999.
% Version 01 by Rodolfo R. Rosales  03-24-1999.
% Version 02 by Rodolfo R. Rosales  03-27-2002.
% Version 03 by Rodolfo R. Rosales  03-30-2002.
% Update     by Rodolfo R. Rosales  03-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
if nargin == 1
   Inpt.Name = '3D plot of solution by characteristics.';
   Inpt.Slid = 0;
   Inpt.Vsbl = 'off';
   Inpt.dX = 0.03;
   Inpt.dY = 0.05;
   Inpt.fW = 0.70;
   Inpt.fH = 0.70;
   Inpt.aW = 0.75;
   Inpt.aH = 0.75;
   %
   Otpt  = demoWBRch_v03_MakeFig(Inpt);
   Fig3D = Otpt.f;% --- 3D figure handle.
   %
   % ---Example button. ======================================================
   %
   StrEx = ['Example #', num2str(Output.EXAMPLE, '%02.0f')];
   Fig3Dexmpl = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'r', ...
             'Interruptible',   'on', ...
             'Units',           'Normalized', ...
             'Position',         [0.02 0.00 0.34 0.07], ...
             'String',           StrEx);
   %
   % --- Close button. =======================================================
   %
   Fig3Dclose = uicontrol( ...
             'Style',           'Pushbutton', ...
             'FontUnits',       'Normalized', ...
             'FontSize',         0.5, ...
             'FontWeight',      'bold', ...
             'BackGroundColor', 'w', ...
             'Units',           'Normalized', ...
             'Position',         [0.04 0.95 0.15 0.04], ...
             'String',          'Close');
   hold on
   grid on
   whitebg(Fig3D, 'k')
elseif nargin == 2
   set(0, 'CurrentFigure', Fig3D)
   hold off
      cla
   hold on
   Fig3Dclose = [];
   Fig3Dexmpl = [];
end
axis([0 2*pi 0 Output.tmax Output.umin Output.umax])
eval(Output.Nice_view);
title(['{\bf', Output.TITL, '}'], 'FontSize', 18, 'Color', 'w')
xlabel('{\bf x}',  'FontSize', 20)
ylabel('{\bf t}',  'FontSize', 20)
zlabel('{\bf u }', 'FontSize', 20, 'Rotation', 0)
surf(Output.xs, Output.ts, Output.us)
colormap(hsv)
shading interp
rotate3d on
%
if isfield(Output, 'Vsbl')
   set(Fig3D, 'Visible', Output.Vsbl)
elseif (nargin == 1) & (~isfield(Output, 'Vsbl'))
   set(Fig3D, 'Visible', 'on')
end
%
if nargout < 3; clear Fig3Dclose; end
if nargout < 2; clear Fig3Dexmpl; end
if nargout < 1; clear Fig3D;      end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF
