function MovieRod = PS311_VibroRod
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function MovieRod = PS311_VibroRod
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Demo illustrating how the longitudinal vibrations of a rod look like.  Makes
% a movie with vibrating rod, where the particle positions are color coded.
%
% The movie is stored in the (optional) output MovieRod ---- one frame in each
% column.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-17-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% ----- Will have a cylindrical rod, with axis along x coordinate axis.
%       Points in the cylinder move parallel to the x-axis.
%
%---------------------- Parameters and other needed variables.
%
R = 0.8;                  % R is the radius of the cylindrical rod..
H = 12;                   % H is the equilibrium length of the rod.
a = 0:0.20*pi:2.20*pi;    % a is the array of polar angles in the rod.
r = 0:0.2*R:R;            % r is the array of radial distances in the rod.
t = 0:pi/20:2*pi;         % t is the array of "times".
A = 1.2;                  % A is the amplitude of the oscillations.
x = -1.0:0.125*H:(H-1.0); % x is the array of "equilibrium" lengths along rod.
Na = length(a);
Nr = length(r);
Nx = length(x);
Nt = length(t);
EJES = [1 9 -7 7 -7 7];
%---------------------- Construct side walls of rod at equilibrium.
xw = (x'*ones(1, Na))'; % This one is needed to get the correct color scale.
yw = R*cos(a);
zw = (R*ones(Nx, 1)*sin(a))';
%---------------------- Construct ends of rod at equilibrium.
x0 = x(1)*ones(Nr, Na);
y0 = r'*cos(a);
z0 = r'*sin(a);
x1 = x(Nx)*ones(Nr, Na);
y1 = r'*cos(a);
z1 = r'*sin(a);
%---------------------- Plot rod at equillibrium.
f1 = figure('Name', 'Vibrating Rod', 'NumberTitle', 'off');
whitebg('c')
surf(x, yw, zw, xw)
shading flat   % default is: faceted (shows lines making figure).
               % other option is: interp (interpolates colors).
colormap(hsv)  %
hold on
surf(x0, y0, z0)
surf(x1, y1, z1)
axis(EJES)
axis('off')
text('String',              '{\bf Longitudinal vibrating rod.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.85], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.10)
text('String',              '{\bf Rod at equillibrium.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.7 0.36], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09)
text('String',              '{\bf Mass points positions: color coded.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.24], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String',              '{\bf Motion tracked by the colors.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.16], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String',              '{\bf Press any key to record the movie.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.08], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String', '{\bf You can see the result afterwards.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.00], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
pause
close(f1)
pause(1)
f2 = figure('Name', 'Vibrating Rod', 'NumberTitle', 'off');
whitebg('k')
%
%----------------------- Make now a "movie" of the rod moving.
%
y = sin(pi*x/H);             % Wave shape.
X = [];                      % X is the array of lengths along rod.
for n=1:Nt
    X  = [X; x + A*cos(t(n))*y]; 
end
MovieRod = moviein(Nt);
for n=1:Nt
    surf(X(n,:), yw, zw, xw)
    shading flat   % default is: faceted (shows lines making figure).
                   % other option is: interp (interpolates colors).
    colormap(hsv)  %
    hold on
    X0 = X(n,1)*ones(Nr, Na);
    surf(X0, y0, z0)
    axis(EJES)
    axis('off')
    text('String',              '{\bf Longitudinal vibrating rod.}', ...
         'Units',               'Normalized', ...
         'Position',             [0.5 0.85], ...
         'HorizontalAlignment', 'Center', ...
         'FontUnits',           'Normalized', ...
         'FontSize',             0.10)
    text('String',              '{\bf Mass points positions: color coded.}', ...
         'Units',               'Normalized', ...
         'Position',             [0.5 0.20], ...
         'HorizontalAlignment', 'Center', ...
         'FontUnits',           'Normalized', ...
         'FontSize',             0.07)
    text('String',              '{\bf Motion tracked by the colors.}', ...
         'Units',               'Normalized', ...
         'Position',             [0.5 0.10], ...
         'HorizontalAlignment', 'Center', ...
         'FontUnits',           'Normalized', ...
         'FontSize',             0.07)
    MovieRod(:,n) = getframe;
    hold off
end
%
% ---------------------- Movie made. Now show it.
%
f3 = figure('Name', 'Vibrating Rod', 'NumberTitle', 'off');
whitebg('c')
surf(x, yw, zw, xw)
shading flat   % default is: faceted (shows lines making figure).
               % other option is: interp (interpolates colors).
colormap(hsv)  %
hold on
surf(x0, y0, z0)
surf(x1, y1, z1)
axis(EJES)
axis('off')
text('String',              '{\bf Longitudinal vibrating rod.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.85], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.10)
text('String',              '{\bf Rod at equillibrium.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.7 0.36], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.09)
text('String',              '{\bf Mass points positions: color coded.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.24], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String',              '{\bf Motion tracked by the colors.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.16], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
text('String',              '{\bf Press any key to see the movie.}', ...
     'Units',               'Normalized', ...
     'Position',             [0.5 0.08], ...
     'HorizontalAlignment', 'Center', ...
     'FontUnits',           'Normalized', ...
     'FontSize',             0.07)
pause
close(f3)
pause(1)
figure(f2)
FLAG = 1;
while FLAG == 1
   figure(f2)
   movie(MovieRod, 8)
   FLAG = input(' Enter 1 to see movie again, else 0. Choice = ');
   if isempty(FLAG); FLAG = 1; end
end
close(f2)
if nargout > 0
   fprintf('\n Movie stored in output the array (MovieRod), each')
   fprintf('\n column a frame. To see it use movie(MovieRod, 8). \n') 
else
   clear MovieRod
end
%
% EOF
