function PS311_Scheme_E(D, L)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function PS311_Scheme_E(D, L)
% --- L = lambda in problem set statements.
% --- D = delta  """""""""""""""""""""""""
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% Demo to study how Friedrichs numerical scheme (for u_t + u_x = 0)
%
% u(n,k+1) = u(n, k) - (1/2)*L*(u(n+1, k) - u(n-1, k))
%                    + (D/2)*(L^2)*(u(n+1, k) - 2*u(n, k) + u(n-1, k))
%
% -- where L = dt/dx and D > 0 is a numerical parameter, behaves. Here u(n, k)
% denotes the value of the solution at x = x_n = n*dx, and t = t_k = k*dt. The
% implementation uses periodic boundary conditions in 0 < x < 2*pi and
% 0 < t < 10.0, with a "chopped" cosine initial condition.
%
% One of the problems in the problem sets asks you to (numerically) study this
% scheme and decide if it is unstable or not. Specifically:
%
%   Is there some positive value of D (say Dc > 0) such that: for D > Dc the
%   scheme is stable? This means that, if D > Dc, you will be able to find a
%   value Lc = Lc(D) > 0, such that: for L = dt/dx < Lc, the solution of the
%   scheme converges to the solution to the PDE as dx ---> 0.
%
%   When the conditions D > Dc and L < Lc are violated, the solutions develop
%   very large amplitude grid scale oscilations.
%
%   Find Dc and, for a few values D > Dc, find Lc.   Do this by experimenting
%   with the script. Note that Dc is a fairly "simple" number.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-27-2001.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- List here: equation to be solved, scheme to be used and scheme numerical
%     parameter that (may) determine stability.
%     SCHtex has the scheme in LaTeX format!
%     EQNtex has the equation in LaTeX format!
%
EQUATN = 'u_t + u_x = 0';
EQNtex = 'u_t + u_x = 0';
SCHEME = 'Friedrichs Scheme';
SCHtex = 'Friedrichs Scheme';
%
% --- Warning if no input:
%
if nargin < 2
   fprintf('\n Script requires as inputs the values:')
   fprintf('\n    L = lambda = dt/dx.')
   fprintf('\n    D = delta  > 0, numerical dissipation parameter.')
   fprintf('\n Please see help for script. \n \n')
   return
end
%
% --- Messages generated by demo, saying what it does.
%
fprintf(['\n Demo for equation: ', EQUATN, '.\n'])
fprintf(['\n SCHEME: ', SCHEME, '.\n'])
fprintf('\n Find the values Dc > 0 and Lc = Lc(D) > 0 needed so that,')
fprintf('\n for D > Dc and L = dt/dx < Lc,   the scheme converges to')
fprintf('\n the solution of the PDE as dx ---> 0. \n \n ')
%
% --- Define parameters for numerical integration.
%     Length = period in space for solution: 0 <= x <= Length.
%     Tfinal = time for integration:         0 <= t <= Tfinal.
%     Npoint = positive integer array with the number of points in the space
%              grid.   Integrations will be done with dx = Length/Npoint(n),
%              with n=1 ... length(Npoint).
%
Length = 2*pi;
Tfinal = 10.0;
Npoint = 10:25:110;
%
% --- Now define initial conditions (given by u0) and integrate.
%     Note that changing the initial conditions or the scheme is simple.
%
for N = Npoint
   dx = Length/N;
   x  = Length*(1:N)/N;
   dt = L*dx;
   u0 = max(0, - cos(x));
   U  = u0;% --- U will have the solution, one time level per row.
   Er = 0;% ---- Will have error.
   T  = 0;% ---- T will have the times computed.
   t  = dt;% --- t will have the time to be computed next.
   up = u0;% --- We use up to store current time level during computation.
   un = u0;% --- """""""""""" next          """""""""""""""""""""""""""""
           %     Need to do this because the periodicity condition forces
           %     a different formula for the ends and mid points.
   while t <= Tfinal + dt
      % --- THESE NEXT THREE IMPLEMENT THE SCHEME.
      un(2:(N-1)) = up(2:(N-1)) - (1/2)*L*(up(3:N) - up(1:N-2)) ...
                  + (D/2)*(L^2)*(up(3:N) - 2*up(2:(N-1)) + up(1:(N-2)));
      %
      un(1)       = up(1) - (1/2)*L*(up(2) - up(N)) ...
                  + (D/2)*(L^2)*(up(2) - 2*up(1) + up(N));
      un(N)       = up(N) - (1/2)*L*(up(1) - up(N-1)) ...
                  + (D/2)*(L^2)*(up(1) - 2*up(N) + up(N-1));
      %
      U  = [U; un];
      T  = [T; t];
      ue = max(0, - cos(x-t));% --- EXACT SOLUTION
      Er = max(Er, max(abs(ue-un)));
      up = un;
      t  = t + dt;
   end
   zmax = max(max(U));
   zmin = min(min(U));
   figure('Name',       ['Solution with N = ', num2str(N), ...
                         ' points in space.'], ...
          'NumberTitle', 'off')
   whitebg('k')
   mesh([0, x], T, [U(:, N), U]);
   view(-55, 40)
   hold on
   grid on
   rotate3d on
   axis([0 Length 0 (t-dt) zmin zmax])
   set(gca, 'LineWidth',   2, ...
            'Position',    [0.1500 0.1000 0.7350 0.7650], ...
            'FontWeight', 'bold', ...
            'FontSize',    16)
   colormap(hsv)
   %
   % --- Titles, labels, and other displayed info.
   %
   text('String',              'dt/dx', ...
        'Units',               'Normalized', ...
        'Position',             [0.780 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               [' = ', num2str(L, '%5.3f')], ...
        'Units',               'Normalized', ...
        'Position',             [0.930 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              'dx', ...
        'Units',               'Normalized', ...
        'Position',             [0.780 1.00], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              ' = 2 \pi / N', ...
        'Units',               'Normalized', ...
        'Position',             [0.930 1.00], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              'N', ...
        'Units',               'Normalized', ...
        'Position',             [0.780 0.93], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               [' = ', num2str(N)], ...
        'Units',               'Normalized', ...
        'Position',             [0.930 0.93], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               SCHtex, ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               ['\delta = D = ', num2str(D)], ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 1.00], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               EQNtex, ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 0.02], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              ['Error = ', ...
                                num2str(Er, '%3.1e')], ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 -0.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.05)
   xlabel('{\bf x}',  'FontSize', 22)
   ylabel('{\bf t}',  'FontSize', 22)
   zlabel('{\bf u}',  'FontSize',             22, ...
                      'HorizontalAlignment', 'Right', ...
                      'Rotation', 0)
   if N < Npoint(length(Npoint))
      fprintf('\n Press any key to continue.')
      pause
   end
end
fprintf('\n')
fprintf('\n Rotate 3D is on in the figures.')
fprintf('\n Type "close all" to close the figures. \n')
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% EOF
