function PS311_Scheme_A
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function PS311_Scheme_A
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
%
% Demo to study how the numerical scheme (for the equation u_t + u_x = 0)
%
% u(n,k+1) = u(n, k) - (dt/dx)*(u(n+1, k) - u(n, k))
%
% behaves.   Here u(n, k) denotes the value of the solution at x = x_n = n*dx,
% and t = t_k = k*dt.  The implementation uses periodic boundary conditions in
% 0 < x < 2*pi and 0 < t < 0.5, with a "chopped" cosine initial condition.
%
% One of the problems in the problem sets asks you to (numerically) study this
% scheme and decide if it is unstable or not. Specifically:
%
%   Is there some positive value of L = dt/dx  (say Lc > 0)  such that, for
%   L < Lc, the solution of the scheme converges to the solution to the PDE
%   as dx ---> 0.  In this case the scheme is stable.
%
%   Else, you will find that -- as dx ---> 0 --  the solutions develop very
%   large amplitude grid scale oscilations. Then the scheme is unstable.
%
%   If there is an Lc, find it (approximately) experimenting with the script.
%
%   WARNING: even a stable scheme will blow up if L > Lc. So, observing
%            blow up for one L is not enough to conclude stability.
%            This does not mean you have to check arbitrarily small L's
%            --- since, typically, Lc is O(1).
%
%   CODE HAS BEEN WRITTEN SO THAT REPLACING THE SCHEME AND EQUATION IS EASY.
%   The parts where changes need to be made are marked by the string:  @#@
%   There are just 9 lines where changes may be needed. In general, if these
%   9 lines are adjusted properly, the new script ought to work fine.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-27-2001.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% --- List here: equation to be solved, scheme to be used and scheme numerical
%     parameter that (may) determine stability.
%     SCHtex has the scheme in LaTeX format!
%     EQNtex has the equation in LaTeX format!
%
EQUATN = 'u_t + u_x = 0';% --- @#@
EQNtex = 'u_t + u_x = 0';% --- @#@
SCHEME = 'u(n, k+1) = u(n, k) - (dt/dx)*(u(n+1, k) - u(n, k))';% --- @#@
LAMBDA = 'dt/dx';% --- @#@
SCHtex = 'u_n^{k+1} = u_n^k - (dt/dx)(u_{n+1}^k - u_n^k)';% --- @#@
%
% --- Messages generated by demo, saying what it does.
%
fprintf(['\n Demo for equation: ', EQUATN, '.\n'])
fprintf(['\n SCHEME: ', SCHEME, '.\n'])
fprintf('\n Find if the scheme is consistent and stable: ')
fprintf('\n As dx ---> 0, is there a critical value LAMBDA_cr > 0 such')
fprintf(['\n that, for LAMBDA = ', LAMBDA, ' < LAMBDA_cr, the numerical'])
fprintf('\n solution converges to the true solution? \n \n')
%
% --- Define parameters for numerical integration.
%     Length = period in space for solution: 0 <= x <= Length.
%     Tfinal = time for integration:         0 <= t <= Tfinal.
%     Npoint = positive integer array with the number of points in the space
%              grid.   Integrations will be done with dx = Length/Npoint(n),
%              with n=1 ... length(Npoint).
%     lambda = value given to the numerical parameter in the scheme.
%
Length = 2*pi;
Tfinal = 0.5;% --- @#@
Npoint = 15:20:135;% --- @#@
lambda = input(['  Enter the value of lambda = ', LAMBDA, ' = ']);
if isempty(lambda); lambda = 1; end
fprintf('\n')
%
% --- Now define initial conditions (given by u0) and integrate.
%     Note that changing the initial conditions or the scheme is simple.
%
for N = Npoint
   dx = Length/N;
   x  = Length*(1:N)/N;
   dt = lambda*dx; % --- @#@ WATCH OUT, THIS ONE WILL CHANGE WITH SCHEME.
   u0 = max(0, - cos(x));
   U  = u0;% --- U will have the solution, one time level per row.
   T  = 0;% ---- T will have the times computed.
   t  = dt;% --- t will have the time to be computed next.
   up = u0;% --- We use up to store current time level during computation.
   un = u0;% --- """""""""""" next          """""""""""""""""""""""""""""
           %     Need to do this because the periodicity condition forces
           %     a different formula for the ends and mid points.
   while t <= Tfinal + dt
      % --- THESE NEXT TWO IMPLEMENT THE SCHEME.
      un(1:(N-1)) = up(1:(N-1)) - lambda*(up(2:N) - up(1:(N-1)));% --- @#@
      un(N)       = up(N)       - lambda*(up(1)   - up(N));% --- @#@
      U  = [U; un];
      T  = [T; t];
      up = un;
      t  = t + dt;
   end
   zmax = max(max(U));
   zmin = min(min(U));
   figure('Name',       ['Solution with N = ', num2str(N), ...
                         ' points in space.'], ...
          'NumberTitle', 'off')
   whitebg('k')
   mesh([0, x], T, [U(:, N), U]);
   hold on
   grid on
   rotate3d on
   axis([0 Length 0 (t-dt) zmin zmax])
   set(gca, 'LineWidth',   2, ...
            'Position',    [0.1500 0.1000 0.7350 0.7650], ...
            'FontWeight', 'bold', ...
            'FontSize',    16)
   colormap(hsv)
   %
   % --- Titles, labels, and other displayed info.
   %
   text('String',               LAMBDA, ...
        'Units',               'Normalized', ...
        'Position',             [0.780 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               [' = ', num2str(lambda, '%5.3f')], ...
        'Units',               'Normalized', ...
        'Position',             [0.930 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              'dx', ...
        'Units',               'Normalized', ...
        'Position',             [0.780 1.00], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              ' = 2 \pi / N', ...
        'Units',               'Normalized', ...
        'Position',             [0.930 1.00], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',              'N', ...
        'Units',               'Normalized', ...
        'Position',             [0.780 0.93], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               [' = ', num2str(N)], ...
        'Units',               'Normalized', ...
        'Position',             [0.930 0.93], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               SCHtex, ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 1.07], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   text('String',               EQNtex, ...
        'Units',               'Normalized', ...
        'Position',             [-0.10 0.02], ...
        'HorizontalAlignment', 'Left', ...
        'FontWeight',          'Bold', ...
        'FontUnits',           'Normalized', ...
        'FontSize',             0.06)
   xlabel('{\bf x}',  'FontSize', 22)
   ylabel('{\bf t}',  'FontSize', 22)
   zlabel('{\bf u}',  'FontSize',             22, ...
                      'HorizontalAlignment', 'Right', ...
                      'Rotation', 0)
   if N < Npoint(length(Npoint))
      fprintf('\n Press any key to continue.')
      pause
   end
end
fprintf('\n')
fprintf('\n Rotate 3D is on in the figures.')
fprintf('\n Type "close all" to close the figures. \n')
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% EOF
