function  z = lectureENV
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function z = lectureENV
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Demo displaying details of the envelope for the family x = t*cos(a) + a.
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  04-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% ----------------------------- Stuff needed for nice lettering and lines. ---
LW  = 'LineWidth';
MS  = 'MarkerSize';
FS  = 'FontSize';
FN  = 'FontName';
HNB = 'HelveticaNarrowBold';
% ----------------------------- Limits of graphic. --------------------------- 
xmin =  0;
xmax =  3*pi;
ymin = -1.5*pi;
ymax =  1.5*pi;
% ----------------------------- Open up figure and set axis limits. ----------
figure;
whitebg('k');
axis([xmin xmax ymin ymax]);
hold on
% ----------------------------- Plot axis. -----------------------------------
plot([0, 0], [ymin, ymax], '-w', LW, 3) % To make t axis thicker.
plot([xmin, xmax], [0, 0], '-w', LW, 2) % To have an x axis through t = 0.
% ----------------------------- Special tickmarks and labels. ----------------
plot([0, 0.25],  [1, 1], '-m', LW, 3)
plot([0, 0.25], -[1, 1], '-m', LW, 3)
plot(0.5*[pi, pi], 0.175*[-1, 1], '-m', LW, 3)
   text(pi/2-0.24, -0.5, 'p/2',  FN, 'Symbol', FS, 16)
plot(1.5*[pi, pi], 0.175*[-1, 1], '-m', LW, 3)
   text(1.5*pi-0.29,  0.5, '3p/2', FN, 'Symbol', FS, 16)
plot(2.5*[pi, pi], 0.150*[-1, 1], '-m', LW, 3)
   text(2.5*pi-0.29, -0.5, '5p/2', FN, 'Symbol', FS, 16)
% ----------------------------- Plot asymptotes of envelope. -----------------
plot([0, ymax], [0, ymax], '--r', LW, 2)
plot([ymin+2*pi, ymax+2*pi], [ymin, ymax], '--r', LW, 2)
plot([ymin+pi, ymax+pi], [ymax, ymin], '--r', LW, 2)
plot([ymin+3*pi, 3*pi], [ymax, 0], '--r', LW, 2)
% ----------------------------- Plot three branches of envelope. -------------
da = pi/201;   Na = 200;
a = [(da:da:pi-da); (da:da:pi-da) + pi; (da:da:pi-da) + 2*pi];
t = 1./sin(a);
x = t.*cos(a) + a;
for n=1:3 
   plot(x(n, :), t(n, :), '-c', LW, 3);
end
% ----------------------------- Put circles around cusps. --------------------
plot(pi*[0.5, 1.5, 2.5], [1, -1, 1], 'og', MS, 12)
% ----------------------------- Label now sequentially envelope pieces. ------
text(3.5,  3.0, 'A', FN, 'Bold', FS, 16)
text(0.5,  3.0, 'B', FN, 'Bold', FS, 16)
text(6.6, -3.0, 'C', FN, 'Bold', FS, 16)
text(2.5, -3.0, 'D', FN, 'Bold', FS, 16)
text(8.5,  3.0, 'E', FN, 'Bold', FS, 16)
text(5.5,  3.0, 'F', FN, 'Bold', FS, 16)
% ----------------------------- Add labels and title. ------------------------
xlabel('x', FN, HNB, FS, 20)
ylabel('t', FN, HNB, FS, 20)
title('Envelope for  x = t*cos(a) + a.', FN, HNB, FS, 20)
% ----------------------------- Now running text. ----------------------------
fprintf('\n')
disp([ ...
 ' The envelope for x=t*cos(a)+a is given (parametrically) by t=1/sin(a)'; ...
 ' and x=cotan(a)+a.   The FIGURE shows:                                '; ...
 ' (a) The envelope for a in [0, 3*pi] (solid lines).                   '; ...
 ' (b) The asymptotes, with slopes +1 and -1 (dotted lines).            '; ...
 ' (c) The cusps (circles), with coordinates t=+/-1 and x=(0.5+n)*pi.   '; ...
 '                                            Press any key to continue.']);
pause
disp([ ...
 ' As a increases, the envelope curve is traced as follows:             '; ...
 ' (1) For a=0 the envelope starts at infinity along the segment A,  and'; ...
 '     goes down towards the cusp, reached for a=pi/2.                  '; ...
 ' (2) Next the segment B is traced, going towards infinity for a=pi.   '; ...
 ' (3) As a crosses pi, the envelope jumps along an asymptote,  from the'; ...
 '     infinity along B to the infinity along C.                        '; ...
 ' (4) Next, on [pi, 2*pi], the branch C-D is traced, going along C from'; ...
 '     infinity to the cusp (at a=1.5*pi)  and back to infinity along D.'; ...
 ' (5) Again,  as a crosses 2*pi,  the envelope jumps along an asymptote'; ...
 '     from infinity along D to infinity along E.                       '; ...
 ' (6) Next the branch E-F is traced and so on.   A branch is traced for'; ...
 '     each interval [n*pi, (n+1)*pi],  alternating between t>0 and t<0.'; ...
 '     Jumps along asymptotes occur for  a=n*pi  and the cusps occur for'; ...
 '     a=(n+0.5)*pi.                                                    '; ...
 '                                            Press any key to continue.']);
pause
disp([ ...
 ' Notice that the asymptotes correspond to the zeros of sin(a),   where'; ...
 ' the straight lines in the family x=t*cos(a)+a are nearly parallel for'; ...
 ' small variations in a.    The cusps, on the other hand, correspond to'; ...
 ' the maximums and minimums of sin(a), where the degree of to which the'; ...
 ' straight lines converge (or diverge) reaches a maximum.              '; ...
 '                                                                      '; ...
 ' IMPORTANT:     when interpreting this family of straight lines as the'; ...
 '                characteristics for a kinematic equation, only the t>0'; ...
 ' part of the envelope are important. When shocks appear kinematic wave'; ...
 ' equations become IRREVERSIBLE and going back in time is meaningless. ']);
fprintf('\n')

