function  envelope(sc, se, T, a, b, flag)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function envelope(s, T, a, b, Np, flag)
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Function plotting the characteristics and their envelope for the equation
% k_t + c(k) * k_x = 0. USES FUNCTION [C, D] = ch_speed(s, flag)  --- where
% D = dC/ds --- to calculate the             
%     family of lines                x = C(s) * t + s                
% and the envelope                   t = - 1/D(s) ,  x = C(s) * t + s,
% both parametrized by s.           
%   PARAMETERS:                                                     
%         sc        1 by N array with s's to plot characteristics.
%         se        1 by M array with s's to plot the envelope. 
%         T, a, b   Figure will be in range a < x < b and 0 < t < T.
%         flag:     picks example in ch_speed (see help ch_speed )
% NOTE that, generally, it is best to take the ranges in sc and se to be
%      larger than the interval [a b], because characteristics can enter
%      the plotting window from outside this range [a b].
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  04-07-1999.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%                  

[dummy, N] = size(sc);  %=  Gets the number of points in sc.
[dummy, M] = size(se);  %=  Gets the number of points in se.
%=========================  Calculates Ch. Speed and Derivatives.
[C, D] = ch_speed(sc, flag);  
figure %==================  Creates figure window.
whitebg('k')             %  with black background.
hold on %=================  So all that follows goes on same figure.
axis([a b 0 T]) %=========  Sets axis for figure, so that MatLab
%=========================       does not pick them by itself.
xlabel('Space axis: x', 'FontSize', 24, 'FontName', 'Bold')
ylabel('Time axis:  t', 'FontSize', 24, 'FontName', 'Bold')
title('Envelope (red) and Characteristics (green)', ...
      'FontSize', 18, 'FontName', 'HelveticaNarrowBold')
Ttop = T * ones(1, N); %==  Time values for top end of characteristics.
Xtop = C.*Ttop + sc;   %==  Space """"""""""""""""""""""""""""""""""""
Tbot = zeros(1,N);     %==  Time values for bottom of characteristics.
Xbot = sc;             %==  Space """""""""""""""""""""""""""""""""""
for n=1:N              %==  Plots characteristics (thin green lines).
  plot([Xbot(n) Xtop(n)], [Tbot(n) Ttop(n)], '-g')
end
%
%=========================  Speed and derivative along envelope.
[Ce,De]=ch_speed(se, flag);  
%=========================  Stuff that follows is so that the bottom
%=========================  parts of the envelope are not plotted.
%=========================  Else, the lines joining one end at infinity
%=========================  with the other at -infinity will show up.
%=========================  This below pushes all that stuff ABOVE the
%=========================  plot, where it causes no harm.
Dm = 1/(1+T);
for n=1:M 
   if De(n) >= 0 
      De(n) = - Dm; 
   end
end
Te = - 1 ./ De;        %==  Times for envelope.
Xe = Ce.*Te + se;      %==  Space for envelope.
%=========================  Plots the envelope (thick red line).
plot(Xe, Te, '-r', 'LineWidth', 3)
hold off %================  So that other stuff will not be ploted here.
% ***********************************************************************
%% END OF FILE
