function Output = EIKOexample03(N)
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% function Output = EIKOexample03(N)
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
% Provides the data needed to make a plot for the evolution of a wave-front by
% the Eikonal equation (Phi_x)^2 + (Phi_y)^2 = 1 (motion at unit speed, normal
% to the wavefront.)
%
% When N = 0, it should print on the screen a short description of the example
%             and then quit (no output.)
%
% When no input is given, it should provide the structure Output ---- with the
% data needed for the plots. Output must have the fields:
%
% exa .......... String with example number.
% txt .......... String with brief description of the example.
% Nsl .......... Number of slides in example (MUST BE AT LEAST TWO.)
% Nra .......... Number of rays that will be plotted.
% xmin ......... Lower axis limit for x.
% xmax ......... Upper axis limit for x.
% ymin ......... Lower axis limit for y.
% ymax ......... Upper axis limit for y.
% X ............ Nsl by something array. Row n has the x-coordinates
%                for the wave front at a time given in T(n).
% Y ............ Nsl by something array. Row n has the x-coordinates
%                for the wave front at a time given in T(n).
% T ............ 1 by Nsl array. Times the wave-front was computed. T(1) = 0.
% xe ........... x-coordinates for the envelope of rays.
% ye ........... y-coordinates for the envelope of rays.
% xray ......... 1 by Nra array: x-coordinates on t=0 wavefront (for a ray.)
% yray ......... 1 by Nra array: y-coordinates on t=0 wavefront (for a ray.)
% norx ......... 1 by Nra array \ (norx(n), nory(n)) = unit normal to t=0
% nory ......... 1 by Nra array / wavefront at (xray(n), yray(n)).
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 2001-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  02-15-2001.
% Update     by Rodolfo R. Rosales  03-15-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
exa = 'Example 03.';
txt = 'Focusing circular wave-front.';
Nsl = 46;
if nargin == 1
   if N == 0;   fprintf(['\n --- ', exa, ' ', txt]);   end;   return
end
%
xmin = - 1.25;
xmax = + 1.25;
ymin = - 1.25;
ymax = + 1.25;
%
% --- Make wave-fronts.
%
smax = 0.00;   smin = 2*pi;
s = smin + (smax-smin)*(0:200)/200;% --- parameter along wave-fronts.
T = 2.25*(0:Nsl-1)/(Nsl-1);% ----------- times for wave-fronts.
%
for n=1:Nsl
   X(n, :) = (1-T(n))*cos(s);
   Y(n, :) = (1-T(n))*sin(s);
end
%
% --- Make envelope.
%
xe = 0;
ye = 0;
%
% --- Make rays.
%
sray = 2*pi*(0:10)/10;
xray = cos(sray);
norx = - cos(sray);
yray = sin(sray);
nory = - sin(sray);
%
% ____________________________________________________________________________
% --- Store stuff for output. %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
Output.xmin = xmin;   Output.xray = xray;   Output.exa = exa;
Output.xmax = xmax;   Output.yray = yray;   Output.Nra = length(xray);
Output.ymin = ymin;   Output.norx = norx;   Output.Nsl = Nsl;
Output.ymax = ymax;   Output.nory = nory;   Output.txt = txt;
%
Output.X = X;  Output.Y = Y;  Output.T = T;  Output.xe = xe;  Output.ye = ye;
%
if nargout == 0; clear Output; end
%
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
%% EOF


