% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% demoBDIBS
% ____________________________________________________________________________
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
%
%          Demo using backdiff_IBS and iniconBDIBS.   Illustrates the solution
% of u_t + 0.5 * (u^2)_x = 0, shocks included, for several examples.  Periodic
% boundary conditions are used.
%
% u ... Array with solution. Each row is a time slice.
% t ... Column vector array with the times corresponding to u.
% x ... Row vector array with the space grid.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
% Copyright 1999-2008 Massachusetts Institute of Technology
% Version 01 by Rodolfo R. Rosales  03-25-1999.
% Update     by Rodolfo R. Rosales  02-05-2005.
% Update     by Rodolfo R. Rosales  02-10-2008.
% 
% Permission is hereby granted, without payment, to copy this software
% and its documentation, if any,  for non-profit academic and research
% purposes,  provided that the above copyright notice, this paragraph,
% and the following three paragraphs appear in all copies of this
% software. Use of this software constitutes acceptance of these terms
% and conditions.
%
% IN NO EVENT SHALL MIT, OR THE AUTHOR, BE LIABLE TO ANY PARTY FOR
% DIRECT, INDIRECT, SPECIAL, INCIDENTAL, OR CONSEQUENTIAL DAMAGES
% ARISING OUT OF THE USE OF THIS SOFTWARE AND ITS DOCUMENTATION, EVEN
% IF MIT, OR THE AUTHOR, HAVE BEEN ADVISED OF THE POSSIBILITY OF SUCH
% DAMAGE.
%
% MIT, AND THE AUTHOR, SPECIFICALLY DISCLAIM ANY EXPRESS OR IMPLIED
% WARRANTIES INCLUDING, BUT NOT LIMITED TO, THE IMPLIED WARRANTIES OF
% MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, AND
% NON-INFRINGEMENT.
%
% THIS SOFTWARE IS PROVIDED "AS IS." MIT, OR THE AUTHOR, HAVE NO
% OBLIGATION TO PROVIDE MAINTENANCE, SUPPORT, UPDATES, ENHANCEMENTS,
% OR MODIFICATIONS.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
FLAG = 1;  % VARIABLE TO REPEAT EXECUTION ====================================
while FLAG == 1
fprintf('\n Demo includes several options.')
fprintf('\n OPTION = 1 .... "Wavy" initial condition.') 
fprintf('\n OPTION = 2 .... Piecewise constant initial condition.')
fprintf('\n OPTION = 3 .... Piecewise linear initial condition.\n')
OPTION = input('Enter OPTION = ');
%
if OPTION == 1
   [u0, x, dx] = iniconBDIBS(200, 0, 10, [2 5 0.5 1 3], 1);
   t  =  0;
   tt =  0;
   u  = u0;
   uu = u0;
   for n=1:60
      uu = backdiff_IBS(uu, 0.05, dx);
      tt = tt + 0.1;
      u  = [u; uu];
      t  = [t; tt];
   end
   figure
   whitebg('k')
   axis([0 10 0 3 0 10])
   hold on
   grid on
   view(120, 25)
   xlabel('Space', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   ylabel('Time' , 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   zlabel('Solution: u', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   title('Solution of u_t + (0.5*u^2)_x = 0.', ...
   'FontName', 'Bold', 'FontSize', 20)
   surf(x, t, u)
   colormap('hsv')
   shading interp
   hold off
   fprintf('\n The solution is stored in the 61x200 array u.')
   fprintf('\n The space grid is in the       1x200 array x.')
   fprintf('\n The time grid is in the       61x1   array t.\n')
   fprintf('\n Time slices can be printed with plot(x, u(1,:)). \n')
   fprintf('\n Do you want to see a frame by frame movie? \n')
   SEE = input('If YES set SEE to 1, else set it to 0. SEE = ');
   if SEE == 1
      figure
      whitebg('k')
      fprintf('\n Press any key to change to next frame. \n')
      for n=1:35
         plot(x, u(n,:), '-c', 'LineWidth', 3)
         axis([0 10 0 10])
         TIME = num2str(t(n));
         title(['Solution for time t = ', TIME], 'FontName', ...
             'HelveticaNarrowBold', 'FontSize', 20)
         xlabel('Space, x', 'FontName', 'Bold', 'FontSize', 16)
         ylabel('Solution u(x,t)', 'FontName', 'Bold', 'FontSize', 16)
         pause
      end
   fprintf('\n End of frame by frame movie. \n')
   end
%
elseif OPTION == 2
   [u0, x, dx] = iniconBDIBS(200, 0, 10, [2 5 0.5 1 3], 2);
   t  =  0;
   tt =  0;
   u  = u0;
   uu = u0;
   for n=1:30
      uu = backdiff_IBS(uu, 0.1, dx);
      tt = tt + 0.1;
      u  = [u; uu];
      t  = [t; tt];
   end
   figure
   whitebg('k')
   axis([0 10 0 3 0 5])
   hold on
   grid on
   view(130, 25)
   xlabel('Space', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   ylabel('Time' , 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   zlabel('Solution: u', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   title('Solution of u_t + (0.5*u^2)_x = 0.', ...
   'FontName', 'Bold', 'FontSize', 20)
   surf(x, t, u)
   colormap('hsv')
   shading interp
   hold off
   fprintf('\n The solution is stored in the 31x200 array u.')
   fprintf('\n The space grid is in the       1x200 array x.')
   fprintf('\n The time grid is in the       31x1   array t.\n')
   fprintf('\n Time slices can be printed with plot(x, u(1,:)). \n')
   fprintf('\n Do you want to see a frame by frame movie? \n')
   SEE = input('If YES set SEE to 1, else set it to 0. SEE = ');
   if SEE == 1
      figure
      whitebg('k')
      fprintf('\n Press any key to change to next frame. \n')
      for n=1:31
         plot(x, u(n,:), '-c', 'LineWidth', 3)
         axis([0 10 0 5])
         TIME = num2str(t(n));
         title(['Solution for time t = ', TIME], 'FontName', ...
             'HelveticaNarrowBold', 'FontSize', 20)
         xlabel('Space, x', 'FontName', 'Bold', 'FontSize', 16)
         ylabel('Solution u(x,t)', 'FontName', 'Bold', 'FontSize', 16)
         pause
      end
   fprintf('\n End of frame by frame movie. \n')
   end
%
elseif OPTION == 3
   [u0, x, dx] = iniconBDIBS(300, 0, 10, [1 5 4 1 6 2 8 0 9 1 10 0], 3);
   t  =  0;
   tt =  0;
   u  = u0;
   uu = u0;
   for n=1:40
      uu = backdiff_IBS(uu, 0.1, dx);
      tt = tt + 0.1;
      u  = [u; uu];
      t  = [t; tt];
   end
   figure
   whitebg('k')
   axis([0 10 0 4 0 5])
   hold on
   grid on
   view(130, 25)
   xlabel('Space', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   ylabel('Time' , 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   zlabel('Solution: u', 'FontName', 'HelveticaNarrowBold', 'FontSize', 16)
   title('Solution of u_t + (0.5*u^2)_x = 0.', ...
   'FontName', 'Bold', 'FontSize', 20)
   surf(x, t, u)
   colormap('hsv')
   shading interp
   hold off
   fprintf('\n The solution is stored in the 41x300 array u.')
   fprintf('\n The space grid is in the       1x300 array x.')
   fprintf('\n The time grid is in the       41x1   array t.\n')
   fprintf('\n Time slices can be printed with plot(x, u(1,:)). \n')
   fprintf('\n Do you want to see a frame by frame movie? \n')
   SEE = input('If YES set SEE to 1, else set it to 0. SEE = ');
   if SEE == 1
      figure
      whitebg('k')
      fprintf('\n Press any key to change to next frame. \n')
      for n=1:31
         plot(x, u(n,:), '-c', 'LineWidth', 3)
         axis([0 10 0 5])
         TIME = num2str(t(n));
         title(['Solution for time t = ', TIME], 'FontName', ...
             'HelveticaNarrowBold', 'FontSize', 20)
         xlabel('Space, x', 'FontName', 'Bold', 'FontSize', 16)
         ylabel('Solution u(x,t)', 'FontName', 'Bold', 'FontSize', 16)
         pause
      end
   fprintf('\n End of frame by frame movie. \n')
   end
%
% ADD MORE OPTIONS HERE
%
end
FLAG = input(' To continue with demo enter 1; to stop enter 0. Choice = ');
end
clear I  OPTION  TIME  SEE  n  u0  y  dx  tt  uu 
fprintf('\n Bye. \n')
fprintf('\n')        
%
% EOF
