% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
%
% 18.311 (Principles of Applied Mathematics). MIT, Winter 2008. R. R. Rosales.
% ____________________________________________________________________________
% 18311 (HELP .m FILE).
%
% MatLab scripts in the 18311_Toolkit. More information with help script_name.
%
% -------------- Back-Differences for the Inviscid Burgers equation. ---------
%                BackDiff_IBS directory.
%                Solve equation u_t+0.5*(u^2)_x = 0  with backwards difference
%                scheme. Examples with shocks and rarefactions are shown.
%                 
% readmeBDIBS .... File with the contents of the directory BackDiff_IBS.
% demoBDIBS ...... User friendly with screen instructions.
% movieBDIBS ..... Makes a movie illustrating the evolution of the solution.
% iniconBDIBS .... Initial conditions, ready for backdiff_IBS.
% backdiff_IBS ... Backward differences to solve the equation.
%
% -------------- Car_Following_Simple_Model. ---------------------------------
%                Car_Following_Simple_Model directory.
%                Simple ODE car following model for traffic flow.
%
% readmeCFSM ..... File with the contents of the Car_Following_Simple_Model
%                  directory.
% quadCFSM ....... Implements the model for a quadratic flow function and hump
%                  initial condition.
% strangeCFSM .... Implements the model for the flow function Q that follows
%                  from typical state law recommendations and a hump initial
%                  condition.
% randCFSM ....... Implements the model for a quadratic flow function and
%                  random initial conditions.
%
% -------------- Envelopes of characteristics/Caustics -----------------------
%                Envelopes_Caustics directory.
%
% readmeENV ...... File with the contents of the Envelopes_Caustics directory.
% demoENV ........ Demo with examples of families of characteristics and their
%                  envelope.
% envelope ....... Script to compute and plot envelopes and characteristics.
% ch_speed ....... Auxiliary script needed by envelope.  User provided,  but a
%                  a default is given.
% lectureENV ..... Demo showing details of an envelope.
% EIKOdemo ....... Demo for wave folding and caustic formation. Eikonal eqn.
% EIKOexampleNN .. File with an example for EIKOdemo: NN = 01, 02, ...
% EIKO3Ddemo ..... 3D version of EIKOdemo, for surfaces.
% EIKO3DexampleNN  Same as EIKOexampleNN, but used by EIKO3Ddemo. 
%
% -------------- Fourier series and Heat equation scripts (Heat_FT directory):
%                Heat_FT directory.
%
% readmeHFT ...... File with the contents of the Heat_FT directory.
% fourierSC ...... Illustrates the convergence of the Fourier Series of a 2*pi
%                  periodic function F(x) to the function as more & more terms
%                  are added. Several functions F(x) are provided in a menu of
%                  examples, with an option for the user to add his own.
% heatSln ........ Displays the solution of the heat equation  T_t = T_xx as a
%                  function of time, with initial conditions given by the same
%                  functions F(x) used by fourierSC.    Illustrates the use of
%                  spectral techniques for the numerical solution of PDE's.
% gibbsFSE ....... Illustrates the GIBBS phenomenon for convergence of Fourier
%                  series near discontinuities.
% FSFun .......... User provided function for input  into fourierSC   or  into
%                  heatSln, selected when OPTION=0 is picked.   Must be in the
%                  directory from which the user is running MatLab.   Given an
%                  array containing the x variable,  it must produce the array
%                  y with the values of the function.
%                  Example of a FSFun.m file:
%
%                          function y = FSFun(x)
%                          %
%                          y = (x.^2).*(x-2*pi).^2;
%
%                  Note the use of vector operands here  (.* and .^)  required
%                  because both x and y are arrays.  The array x is defined in
%                  both fourierSC and heatSln by: x = 0:dx:2*pi-dx --- some dx
%                  that depends on the (user prescribed) resolution.
%         >>>>>>>> Check help FSFun  for important details about how to define
%                  the function when dealing with discontinuities!
%         >>>>>>>> NOTE: help FSFun will NOT work if the current directory for
%                  MatLab has a user constructed  FSFun.m file already in it.
% FSoption ....... Script to construct the functions F(x) used by heatSln  and
%                  fourierSC ("fancy", with buttons).
% FSoptionP ...... Same as FSoption, but without buttons.
%
% -------------- Problem Set Scripts: ----------------------------------------
%                Problem_Sets directory.
%
% readmePSA ...... File with the contents of the Problem_Sets directory.
% ________________________________________________________________ VIBRATIONS:
% PS311_VibroRod . Vibrating rod demo, illustrating longitudinal vibrations of
%                  a rod. Makes a movie.
% _________________________________________________ NUMERICAL STABILITY DEMOS: 
% PS311_Scheme_A ..... Difference scheme for u_t + u_x = 0.
% PS311_SchemeDIC_A .. """""""""""""""""""""""""""""""""""
% PS311_Scheme_B ..... Difference scheme for u_t + u_x = 0.
% PS311_SchemeDIC_B .. """""""""""""""""""""""""""""""""""
% PS311_Scheme_C ..... Difference scheme for u_t + u_x = 0.
% PS311_SchemeDIC_C .. """""""""""""""""""""""""""""""""""
% PS311_Scheme_D ..... Difference scheme for u_t = u_xx.
% PS311_SchemeDIC_D .. """""""""""""""""""""""""""""""""""
% PS311_Scheme_E ..... Difference scheme for u_t + u_x = 0.
% PS311_SchemeDIC_E .. """""""""""""""""""""""""""""""""""
%
% -------------- Support scripts for 18311 Toolkit. --------------------------
%
% readmeSUP ...... File with the contents of the Support directory.
% MakeFig311_v00 . Setup nice Figure Window on the screen, with a slider.
% MakeFig311_v01 . More advanced version of MakeFig311_v00.
%
% -------------- Wave breaking and characteristics for kinematic waves -------
%                Wave_Breaking directory
%
% readmeWBR ...... File with the contents of the Wave_Breaking directory.
% demoWBRch ...... Shows various examples of evolution by characteristics that
%                  leads to wave-breaking and multiple values.
% demoWBRch_v01 .. More advanced version of demoWBRch.
% demoWBRch_v02 .. More advanced version of demoWBRch_v01.
% demoWBRch_v03 .. More advanced version of demoWBRch_v02.
% evolveWBRch .... General script to show the evolution by characteristics.
%
% -------------- Wave equation and numerical stability scripts ---------------
%                Wave_eqnGBNS directory.
%
% readmeGBNS ..... File with the contents of the Wave_eqnGBNS directory.
% lectureGBNS .... Demo that introduces the subject matter.
% demoGBNS   ..... Demo showing a couple of example solutions of the wave eqn.
% InitGBNS ....... Function script implementing the two numerical schemes, and
%                  two choices of numerical conditions.
% movieGBNS ...... Function script to make movies with the output of InitGBNS.
% movieGBNS_NOTES. Help script: detailed explanations of how movieGBNS works.
%
% GBNS_lecture ... A more elaborate version of lectureGBNS, but with basically
%                  the same contents.
%                  Calls many other scripts, as GBNS_lecture_Readme explains.
%                  GBNS_lecture_2D .......... subscript of GBNS_lecture.
%                  GBNS_lecture_3D .......... subscript of GBNS_lecture.
%                  GBNS_lecture_Compute ..... subscript of GBNS_lecture.
%                  GBNS_lecture_FIG ......... subscript of GBNS_lecture.
%                  GBNS_lecture_FIG_var ..... subscript of GBNS_lecture.
%                  GBNS_lecture_HELP ........ subscript of GBNS_lecture.
%                  GBNS_lecture_Movie ....... subscript of GBNS_lecture.
%                  GBNS_lecture_MSG1 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_MSG2 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_MSG3 ........ subscript of GBNS_lecture.
%                  GBNS_lecture_Readme ...... subscript of GBNS_lecture.
%                  GBNS_lecture_RESET ....... subscript of GBNS_lecture.
%                  GBNS_lecture_SEL ......... subscript of GBNS_lecture.
% GBNS_GScheme ... Solves arbitray initial value problems, with periodic
%                  boundary conditions.
%
% ****************************************************************************
% NOTE:  help 311TC gives a short listing of the scripts in the 18311_Toolkit,
%        just names basically, which is easier to scan.
% %%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%

%
%% EOF
